<?php

namespace App\Exports;

use App\Models\Pegawai;
use Illuminate\Support\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class PegawaiExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    public function collection()
    {
        return Pegawai::orderBy('nama')
            ->get()
            ->map(function ($p) {
                $tgl = null;
                if (!empty($p->tanggal_lahir)) {
                    try {
                        $tgl = Carbon::parse($p->tanggal_lahir)->format('Y-m-d');
                    } catch (\Throwable $e) {
                        $tgl = $p->tanggal_lahir;
                    }
                }

                return [
                    'nama'               => $p->nama,
                    'nip'                => $p->nip,
                    'gol'                => $p->gol,
                    'pangkat_golongan'   => $p->pangkat_golongan,
                    'jabatan'            => $p->jabatan,
                    'status_kepegawaian' => $p->status_kepegawaian,
                    'instansi'           => $p->instansi,
                    'email'              => $p->email,
                    'telepon'            => $p->telepon,
                    'alamat'             => $p->alamat,
                    'tanggal_lahir'      => $tgl,
                    'jenis_kelamin'      => $p->jenis_kelamin,
                ];
            });
    }

    public function headings(): array
    {
        return [
            'nama',
            'nip',
            'gol',
            'pangkat_golongan',
            'jabatan',
            'status_kepegawaian',
            'instansi',
            'email',
            'telepon',
            'alamat',
            'tanggal_lahir',
            'jenis_kelamin',
        ];
    }
}
