<?php

namespace App\Exports;

use App\Models\Sekolah;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class SekolahExport implements FromCollection, WithHeadings
{
    protected $filters;

    public function __construct($filters = [])
    {
        $this->filters = $filters;
    }

    public function collection()
    {
        $query = Sekolah::query()->orderBy('nama');

        if (!empty($this->filters['search'])) {
            $search = $this->filters['search'];
            $query->where(function ($q) use ($search) {
                $q->where('nama', 'like', "%{$search}%")
                  ->orWhere('npsn', 'like', "%{$search}%")
                  ->orWhere('sekolah_id', 'like', "%{$search}%");
            });
        }

        if (!empty($this->filters['kabupaten'])) {
            $query->where('kabupaten', $this->filters['kabupaten']);
        }

        if (!empty($this->filters['jenjang'])) {
            $query->where('jenjang', $this->filters['jenjang']);
        }

        if (!empty($this->filters['status_sekolah'])) {
            $query->where('status_sekolah', $this->filters['status_sekolah']);
        }

        return $query->get([
            'sekolah_id',
            'semester',
            'npsn',
            'nama',
            'nama_nomenklatur',
            'bentuk_pendidikan',
            'jenjang',
            'alamat_jalan',
            'nama_dusun',
            'desa_kelurahan',
            'kecamatan',
            'kabupaten',
            'kode_pos',
            'nomor_telepon',
            'email',
            'kebutuhan_khusus',
            'status_sekolah',
            'yayasan',
            'keaktifan',
            'partisipasi_bos',
            'waktu_penyelenggaraan',
            'akses_internet',
            'akreditasi',
            'angkatan_psp',
        ]);
    }

    public function headings(): array
    {
        return [
            'sekolah_id',
            'semester',
            'npsn',
            'nama',
            'nama_nomenklatur',
            'bentuk_pendidikan',
            'jenjang',
            'alamat_jalan',
            'nama_dusun',
            'desa_kelurahan',
            'kecamatan',
            'kabupaten',
            'kode_pos',
            'nomor_telepon',
            'email',
            'kebutuhan_khusus',
            'status_sekolah',
            'yayasan',
            'keaktifan',
            'partisipasi_bos',
            'waktu_penyelenggaraan',
            'akses_internet',
            'akreditasi',
            'angkatan_psp',
        ];
    }
}
