<?php

namespace App\Http\Controllers\Admin;

use App\Models\Pelatihan;
use Illuminate\Http\Request;
use App\Models\PelatihanKelas;
use App\Models\PelatihanKelasFasil;
use App\Http\Controllers\Controller;

class KelasController extends Controller
{
    public function index(Request $request)
    {
        Pelatihan::query()
            ->select(['id'])
            ->chunkById(200, function ($items) {
                foreach ($items as $p) {
                    foreach (['A', 'B', 'C', 'D'] as $kode) {
                        PelatihanKelas::firstOrCreate(
                            ['pelatihan_id' => $p->id, 'kode_kelas' => $kode],
                            ['nama_kelas' => 'Kelas ' . $kode]
                        );
                    }
                }
            });

        $pelatihanId = $request->input('pelatihan_id');
        $search = $request->input('search');

        $kelas = PelatihanKelas::query()
            ->with(['pelatihan', 'adminLms', 'fasil'])
            ->withCount('peserta')
            ->when($pelatihanId, fn($q) => $q->where('pelatihan_id', $pelatihanId))
            ->when($search, function ($q) use ($search) {
                $like = "%{$search}%";
                $q->where('nama_kelas', 'like', $like)
                    ->orWhere('kode_kelas', 'like', $like)
                    ->orWhereHas('pelatihan', fn($p) => $p->where('nama_pelatihan', 'like', $like));
            })
            ->orderByDesc('id')
            ->paginate(20)
            ->withQueryString();

        $pelatihanList = Pelatihan::orderBy('nama_pelatihan')->get();

        return view('admin.kelas.index', compact('kelas', 'pelatihanList', 'pelatihanId', 'search'));
    }

    public function storeFasil(Request $request, PelatihanKelas $kelas)
    {
        $request->validate([
            'nama_fasil'     => 'required|string|max:255',
            'instansi'       => 'nullable|string|max:255',
            'tanggal'        => 'required|date',
            'waktu_mulai'    => 'required',
            'waktu_selesai'  => 'required',
            'jp'             => 'required|integer|min:1',
            'tempat'         => 'nullable|string|max:255',
            'keterangan'     => 'nullable|string',
        ]);

        PelatihanKelasFasil::create([
            'pelatihan_kelas_id' => $kelas->id,
            'nama_fasil' => $request->nama_fasil,
            'instansi' => $request->instansi,
            'tanggal' => $request->tanggal,
            'waktu_mulai' => $request->waktu_mulai,
            'waktu_selesai' => $request->waktu_selesai,
            'jp' => $request->jp,
            'tempat' => $request->tempat,
            'keterangan' => $request->keterangan,
        ]);

        return back()->with('success', 'Fasilitator berhasil ditambahkan');
    }

    public function destroyFasil(PelatihanKelas $kelas, PelatihanKelasFasil $fasil)
    {
        // pengaman: pastikan fasil milik kelas ini
        if ($fasil->pelatihan_kelas_id !== $kelas->id) {
            abort(403);
        }

        $fasil->delete();

        return back()->with('success', 'Fasilitator berhasil dihapus');
    }
}
