<?php

namespace App\Http\Controllers;

use App\Models\DaftarHadir;
use App\Models\DaftarHadirDetail;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;

class DaftarHadirNarasumberController extends Controller
{
    public function index($id)
    {
        $daftarHadir = DaftarHadir::with([
            'detail' => fn($q) => $q->where('tipe','narasumber')
        ])->findOrFail($id);

        return view(
            'admin.kegiatan.daftar-hadir.narasumber',
            compact('daftarHadir')
        );
    }

    public function create($id)
    {
        $daftarHadir = DaftarHadir::findOrFail($id);

        return view(
            'admin.kegiatan.daftar-hadir.narasumber_create',
            compact('daftarHadir')
        );
    }

    public function store(Request $request, $id)
    {
        $request->validate([
            'nama_manual'   => 'required|array|min:1',
            'nama_manual.*' => 'required|string|max:255',
        ]);

        $daftarHadir = DaftarHadir::findOrFail($id);

        foreach ($request->nama_manual as $nama) {
            $daftarHadir->detail()->create([
                'tipe' => 'narasumber',
                'nama_manual' => trim($nama),
            ]);
        }

        return redirect()
            ->route('daftar-hadir-narasumber.index',$id)
            ->with('success','Narasumber berhasil ditambahkan');
    }

    public function edit($id)
    {
        $daftarHadir = DaftarHadir::with([
            'detail' => fn($q) => $q->where('tipe','narasumber')
        ])->findOrFail($id);

        return view(
            'admin.kegiatan.daftar-hadir.narasumber_edit',
            compact('daftarHadir')
        );
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'manual_existing.*' => 'nullable|string|max:255',
            'manual_new.*'      => 'nullable|string|max:255',
        ]);

        $daftarHadir = DaftarHadir::findOrFail($id);

        // update yang sudah ada
        if ($request->manual_existing) {
            foreach ($request->manual_existing as $detailId => $nama) {
                DaftarHadirDetail::where('id',$detailId)
                    ->where('daftar_hadir_id',$id)
                    ->where('tipe','narasumber')
                    ->update([
                        'nama_manual' => trim($nama)
                    ]);
            }
        }

        // tambah baru
        if ($request->manual_new) {
            foreach ($request->manual_new as $nama) {
                if ($nama) {
                    $daftarHadir->detail()->create([
                        'tipe' => 'narasumber',
                        'nama_manual' => trim($nama),
                    ]);
                }
            }
        }

        return redirect()
            ->route('daftar-hadir-narasumber.index',$id)
            ->with('success','Narasumber berhasil diperbarui');
    }

    /**
     * Hapus SATU narasumber (bukan semua)
     */
    public function destroy($detailId)
    {
        $detail = DaftarHadirDetail::where('id',$detailId)
            ->where('tipe','narasumber')
            ->firstOrFail();

        $detail->delete();

        return back()->with('success','Narasumber berhasil dihapus');
    }

    public function cetak($id)
    {
        $daftarHadir = DaftarHadir::with([
            'detail' => fn($q)=>$q->where('tipe','narasumber')
        ])->findOrFail($id);

        $pdf = Pdf::loadView(
            'admin.kegiatan.pdf.daftar-hadir-narasumber',
            compact('daftarHadir')
        );

        return $pdf->stream('daftar-hadir-narasumber.pdf');
    }
}
