<?php

namespace App\Http\Controllers;

use App\Models\Guru;
use App\Models\Sekolah;
use App\Models\Pelatihan;
use App\Models\PelatihanPeserta;
use Illuminate\Support\Facades\Auth;

class PesertaDashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_guru' => Guru::count(),
            'total_sekolah' => Sekolah::count(),
            'total_pelatihan' => Pelatihan::count(),
            'total_peserta_pelatihan' => PelatihanPeserta::count(),
        ];

        return view('user.dashboard', compact('stats'));
    }

    public function pelatihanSaya()
    {
        $user = Auth::user();

        if (!$user->guru_id) {
            $pelatihanSaya = collect();
            $stat = [
                'total_diikuti' => 0,
                'selesai'       => 0,
                'sertifikat'    => 0,
            ];
        } else {
            $pelatihanSaya = PelatihanPeserta::with('pelatihan')
                ->where('guru_id', $user->guru_id)
                ->orderByDesc('created_at')
                ->get();

            $stat = [
                'total_diikuti' => $pelatihanSaya->count(),
                'selesai'       => $pelatihanSaya->where('status_keikutsertaan', 'lulus')->count(),
                'sertifikat'    => $pelatihanSaya->filter(function ($p) {
                    return $p->status_keikutsertaan === 'lulus' && $p->sertifikat_path;
                })->count(),
            ];
        }

        return view('admin.peserta.pelatihan_saya', compact('pelatihanSaya', 'stat'));
    }
}
