<?php

namespace App\Http\Controllers\Portal;

use App\Http\Controllers\Controller;
use App\Models\BidangBahasa;
use App\Models\Guru;
use App\Models\Sekolah;
use Illuminate\Http\Request;

class PortalGuruController extends Controller
{
    public function index(Request $request)
    {
        $filters = [
            'q' => $request->query('q'),
            'wilayah' => $request->query('wilayah'),
            'jenjang' => $request->query('jenjang'),
            'bidang_bahasa_id' => $request->query('bidang_bahasa_id'),
        ];

        $query = Guru::query()
            ->with(['sekolah', 'bidangBahasa'])
            ->orderBy('nama_guru');

        if (!empty($filters['q'])) {
            $k = $filters['q'];
            $query->where(function ($q) use ($k) {
                $q->where('nama_guru', 'like', "%{$k}%")
                    ->orWhere('nik', 'like', "%{$k}%")
                    ->orWhere('nip', 'like', "%{$k}%")
                    ->orWhere('nuptk', 'like', "%{$k}%")
                    ->orWhereHas('sekolah', function ($sq) use ($k) {
                        $sq->where('nama', 'like', "%{$k}%")
                            ->orWhere('npsn', 'like', "%{$k}%");
                    });
            });
        }

        if (!empty($filters['wilayah'])) {
            $query->whereHas('sekolah', function ($q) use ($filters) {
                $q->where('kabupaten', $filters['wilayah']);
            });
        }

        if (!empty($filters['jenjang'])) {
            $query->whereHas('sekolah', function ($q) use ($filters) {
                $q->where('jenjang', $filters['jenjang']);
            });
        }

        if (!empty($filters['bidang_bahasa_id'])) {
            $query->where('bidang_bahasa_id', $filters['bidang_bahasa_id']);
        }

        $guru = $query->paginate(10)->withQueryString();

        $options = [
            'wilayah' => Sekolah::select('kabupaten')
                ->whereNotNull('kabupaten')
                ->distinct()
                ->orderBy('kabupaten')
                ->pluck('kabupaten')
                ->toArray(),
            'jenjang' => Sekolah::select('jenjang')
                ->whereNotNull('jenjang')
                ->distinct()
                ->orderBy('jenjang')
                ->pluck('jenjang')
                ->toArray(),
            'bidang' => BidangBahasa::orderBy('nama_bahasa')->get(),
        ];

        return view('portal.guru.index', compact('guru', 'filters', 'options'));
    }

    public function show(Guru $guru)
    {
        $guru->load(['sekolah', 'bidangBahasa']);

        $pelatihan = $guru->pesertaPelatihan()
            ->with('pelatihan')
            ->latest()
            ->get();

        return view('portal.guru.show', compact('guru', 'pelatihan'));
    }
}
