<?php

namespace App\Http\Controllers;

use App\Models\Guru;
use App\Models\Pelatihan;
use App\Models\RegistrasiPelatihan;
use Illuminate\Http\Request;

class RegistrasiPelatihanController extends Controller
{
    public function create(Request $request)
    {
        $pelatihanId = $request->query('pelatihan_id');
        $pelatihan = $pelatihanId ? Pelatihan::find($pelatihanId) : null;

        return view('admin.registrasi.create', compact('pelatihan'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'pelatihan_id' => 'nullable|integer',
            'nama_kegiatan' => 'required|string|max:255',

            'nama' => 'required|string|max:255',
            'nik' => 'required|string|max:50',
            'nip' => 'nullable|string|max:50',
            'jabatan' => 'nullable|string|max:255',
            'pangkat_golongan' => 'nullable|string|max:100',
            'agama' => 'nullable|string|max:50',
            'jenis_kelamin' => 'nullable|string|max:20',
            'tempat_lahir' => 'nullable|string|max:100',
            'tanggal_lahir' => 'nullable|date',
            'no_hp' => 'nullable|string|max:50',
            'email_pribadi' => 'nullable|email|max:255',
            'pendidikan_terakhir' => 'nullable|string|max:100',
            'prodi' => 'nullable|string|max:150',

            'unit_kerja' => 'nullable|string|max:255',
            'alamat_unit_kerja' => 'nullable|string',
            'kab_kota_unit' => 'nullable|string|max:100',
            'provinsi_unit' => 'nullable|string|max:100',
            'kode_pos_unit' => 'nullable|string|max:10',
            'telp_instansi' => 'nullable|string|max:50',

            'alamat_rumah' => 'nullable|string',
            'kab_kota_rumah' => 'nullable|string|max:100',
            'provinsi_rumah' => 'nullable|string|max:100',
            'kode_pos_rumah' => 'nullable|string|max:10',

            'npwp' => 'nullable|string|max:50',
            'nama_bank' => 'nullable|string|max:50',
            'no_rekening' => 'nullable|string|max:50',
        ]);

        // 1) UPSERT ke tabel GURU berdasarkan NIK (paling stabil)
        $guru = Guru::updateOrCreate(
            ['nik' => $data['nik']],
            [
                'nama_guru' => $data['nama'],
                'nip' => $data['nip'] ?? null,
                'jabatan' => $data['jabatan'] ?? null,
                'pangkat_golongan' => $data['pangkat_golongan'] ?? null,
                'agama' => $data['agama'] ?? null,
                'jenis_kelamin' => $data['jenis_kelamin'] ?? null,
                'tempat_lahir' => $data['tempat_lahir'] ?? null,
                'tanggal_lahir' => $data['tanggal_lahir'] ?? null,
                'no_hp' => $data['no_hp'] ?? null,

                // map email pribadi → email di guru (atau kamu bisa bikin kolom baru)
                'email' => $data['email_pribadi'] ?? null,

                'pendidikan_terakhir' => $data['pendidikan_terakhir'] ?? null,
                'prodi' => $data['prodi'] ?? null,

                // unit kerja
                'instansi' => $data['unit_kerja'] ?? null,
                'alamat_instansi' => $data['alamat_unit_kerja'] ?? null,
                'kabupaten_kota' => $data['kab_kota_unit'] ?? null,
                'provinsi' => $data['provinsi_unit'] ?? null,
                'kode_pos' => $data['kode_pos_unit'] ?? null,
                'telp_instansi' => $data['telp_instansi'] ?? null,

                // rumah
                'alamat_rumah' => $data['alamat_rumah'] ?? null,

                // pajak & bank
                'npwp' => $data['npwp'] ?? null,
                'nama_bank' => $data['nama_bank'] ?? null,
                'no_rekening' => $data['no_rekening'] ?? null,
            ]
        );

        // 2) Simpan registrasi (snapshot)
        $reg = RegistrasiPelatihan::create([
            ...$data,
            'guru_id' => $guru->id,
        ]);

        // 3) arahkan ke halaman sukses / atau langsung ke kuitansi/spd create
        return redirect()
            ->route('registrasi.success', $reg->id)
            ->with('success', 'Registrasi berhasil disimpan.');
    }

    public function success($id)
    {
        $reg = RegistrasiPelatihan::with('guru')->findOrFail($id);
        return view('registrasi.success', compact('reg'));
    }
}

