<?php

namespace App\Http\Controllers\Select2;

use App\Models\Guru;
use App\Models\Pegawai;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PtkSelect2Controller extends Controller
{
    public function index(Request $request)
    {
        $q = $request->q;

        $guru = Guru::select('id', 'nama_guru as nama', 'nip')
            ->when($q, fn($x) =>
                $x->where('nama_guru','like',"%$q%")
                  ->orWhere('nip','like',"%$q%")
            )
            ->limit(15)
            ->get()
            ->map(fn($g) => [
                'id'   => 'guru_'.$g->id,
                'text' => 'Guru — '.$g->nama.($g->nip ? " ({$g->nip})" : '')
            ]);

        $pegawai = Pegawai::select('id', 'nama', 'nip', 'jabatan')
            ->when($q, fn($x) =>
                $x->where('nama','like',"%$q%")
                  ->orWhere('nip','like',"%$q%")
            )
            ->limit(15)
            ->get()
            ->map(fn($p) => [
                'id'   => 'pegawai_'.$p->id,
                'text' => 'Pegawai — '.$p->nama.($p->nip ? " ({$p->nip})" : '')
            ]);

        return response()->json([
            'results' => $guru->merge($pegawai)->values()
        ]);
    }
}