<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

use App\Models\Visitor;
use Carbon\Carbon;
class TrackVisitor
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        // Jangan hitung request asset / ajax
        if ($request->isMethod('get') && ! $request->ajax()) {

            Visitor::firstOrCreate([
                'ip_address' => $request->ip(),
                'visit_date' => Carbon::today(),
            ]);
        }

        return $next($request);
    }
}
