<?php

namespace App\Imports;

use App\Models\Sekolah;
use Maatwebsite\Excel\Row;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class SekolahImport implements OnEachRow, WithHeadingRow
{
    public function onRow(Row $row): void
    {
        $r = $row->toArray();

        // minimal punya sekolah_id atau npsn
        if (empty($r['sekolah_id']) && empty($r['npsn'])) {
            return;
        }

        Sekolah::updateOrCreate(
            ['sekolah_id' => $r['sekolah_id'] ?? $r['npsn']],
            [
                'semester'             => $r['semester'] ?? null,
                'npsn'                 => $r['npsn'] ?? null,
                'nama'                 => $r['nama'] ?? null,
                'nama_nomenklatur'     => $r['nama_nomenklatur'] ?? null,
                'bentuk_pendidikan'    => $r['bentuk_pendidikan'] ?? null,
                'jenjang'              => $r['jenjang'] ?? null,
                'alamat_jalan'         => $r['alamat_jalan'] ?? null,
                'nama_dusun'           => $r['nama_dusun'] ?? null,
                'desa_kelurahan'       => $r['desa_kelurahan'] ?? null,
                'kecamatan'            => $r['kecamatan'] ?? null,
                'kabupaten'            => $r['kabupaten'] ?? null,
                'kode_pos'             => $r['kode_pos'] ?? null,
                'nomor_telepon'        => $r['nomor_telepon'] ?? null,
                'email'                => $r['email'] ?? null,
                'kebutuhan_khusus'     => $r['kebutuhan_khusus'] ?? null,
                'status_sekolah'       => $r['status_sekolah'] ?? null,
                'yayasan'              => $r['yayasan'] ?? null,
                'keaktifan'            => $r['keaktifan'] ?? null,
                'partisipasi_bos'      => $r['partisipasi_bos'] ?? null,
                'waktu_penyelenggaraan'=> $r['waktu_penyelenggaraan'] ?? null,
                'akses_internet'       => $r['akses_internet'] ?? null,
                'akreditasi'           => $r['akreditasi'] ?? null,
                'angkatan_psp'         => $r['angkatan_psp'] ?? null,
            ]
        );
    }
}

