<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Guru extends Model
{
    protected $table = 'guru';

    protected $fillable = [
        'nik','semester','sekolah_id','nama_guru','nip','instansi', 'jabatan', 'kab_kota', 'provinsi', 'jenis_kelamin','tempat_lahir','tanggal_lahir',
        'nuptk','status_kepegawaian','jenis_ptk','agama','email','status_keaktifan',
        'tmt_pengangkatan','lembaga_pengangkat','pangkat_golongan','keahlian_laboratorium',
        'status_perkawinan','sudah_lisensi_kepala_sekolah','pernah_diklat_kepengawasan',
        'mampu_handle_kk','keahlian_braille','keahlian_bhs_isyarat','ptk_induk',
        'jenis_keluar','riwayat_sertifikasi_bidang_studi','riwayat_sertifikasi_jenis_sertifikasi',
        'riwayat_sertifikasi_tahun_sertifikasi','riwayat_sertifikasi_nomor_sertifikat',
        'riwayat_sertifikasi_nrg','riwayat_pendidikan_formal_bidang_studi',
        'riwayat_pendidikan_formal_jenjang_pendidikan','jabatan_ptk',
        'foto'
    ];    

    protected $casts = [
        'tanggal_lahir' => 'date',
    ];

    public function bidangBahasa()
    {
        return $this->belongsTo(BidangBahasa::class, 'bidang_bahasa_id');
    }

    public function pelatihan()
    {
        return $this->belongsToMany(Pelatihan::class, 'pelatihan_peserta')
            ->withPivot(['status_keikutsertaan', 'nilai', 'sertifikat_path', 'tanggal_selesai'])
            ->withTimestamps();
    }

    public function pesertaPelatihan()
    {
        return $this->hasMany(PelatihanPeserta::class, 'guru_id');
    }

    public function sekolah()
    {
        return $this->belongsTo(Sekolah::class, 'sekolah_id');
    }

    public function registrasiTerakhir()
    {
        return $this->hasOne(\App\Models\RegistrasiPelatihan::class, 'guru_id')->latestOfMany();
    }

    

}
