<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RegistrasiPelatihan extends Model
{
    protected $table = 'registrasi_pelatihan';

    protected $fillable = [
        'pelatihan_id','guru_id','nama_kegiatan',
        'nama','nik','nip','jabatan','pangkat_golongan','agama','jenis_kelamin','tempat_lahir','tanggal_lahir',
        'no_hp','email_pribadi','pendidikan_terakhir','prodi',
        'unit_kerja','alamat_unit_kerja','kab_kota_unit','provinsi_unit','kode_pos_unit','telp_instansi',
        'alamat_rumah','kab_kota_rumah','provinsi_rumah','kode_pos_rumah',
        'npwp','nama_bank','no_rekening',
    ];

    public function guru()
    {
        return $this->belongsTo(Guru::class, 'guru_id');
    }

    public function pelatihan()
    {
        return $this->belongsTo(Pelatihan::class, 'pelatihan_id');
    }
}
