<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RegistrasiPeserta extends Model
{
    protected $table = 'registrasi_peserta';

    protected $fillable = [
        'user_id',
        'pelatihan_id',
        'nama_kegiatan',
        'nama',
        'nik',
        'nip',
        'jabatan',
        'pangkat_golongan',
        'agama',
        'jenis_kelamin',
        'tempat_lahir',
        'tanggal_lahir',
        'no_hp',
        'email_pribadi',
        'pendidikan_terakhir',
        'prodi',
        'unit_kerja',
        'npsn', //baru
        'alamat_unit_kerja',
        'kab_kota_unit',
        'provinsi_unit',
        'kode_pos_unit',
        'telp_instansi',
        'alamat_rumah',
        'kab_kota_rumah',
        'provinsi_rumah',
        'kode_pos_rumah',
        'npwp',
        'no_rekening',
        'bank',
        'foto',
    ];

    public function pelatihan()
    {
        return $this->belongsTo(Pelatihan::class, 'pelatihan_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
