<?php

namespace App\Support;

class Terbilang
{
    public static function make($number): string
    {
        $number = (int) $number;
        $basic = ["", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas"];

        if ($number < 12) {
            return $basic[$number];
        } elseif ($number < 20) {
            return self::make($number - 10) . " belas";
        } elseif ($number < 100) {
            return self::make((int)($number / 10)) . " puluh " . self::make($number % 10);
        } elseif ($number < 200) {
            return "seratus " . self::make($number - 100);
        } elseif ($number < 1000) {
            return self::make((int)($number / 100)) . " ratus " . self::make($number % 100);
        } elseif ($number < 2000) {
            return "seribu " . self::make($number - 1000);
        } elseif ($number < 1000000) {
            return self::make((int)($number / 1000)) . " ribu " . self::make($number % 1000);
        } elseif ($number < 1000000000) {
            return self::make((int)($number / 1000000)) . " juta " . self::make($number % 1000000);
        }

        return (string) $number;
    }
}
