<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sekolah', function (Blueprint $table) {
            $table->id();
            $table->string('sekolah_id')->unique();
            $table->string('semester')->nullable();
            $table->string('npsn')->nullable();
            $table->string('nama');
            $table->string('nama_nomenklatur')->nullable();
            $table->string('bentuk_pendidikan')->nullable();
            $table->string('jenjang')->nullable();
        
            $table->string('alamat_jalan')->nullable();
            $table->string('nama_dusun')->nullable();
            $table->string('desa_kelurahan')->nullable();
            $table->string('kecamatan')->nullable();
            $table->string('kabupaten')->nullable();
            $table->string('kode_pos', 10)->nullable();
            $table->string('nomor_telepon', 50)->nullable();
            $table->string('email')->nullable();
        
            $table->string('kebutuhan_khusus')->nullable();
            $table->string('status_sekolah')->nullable();
            $table->string('yayasan')->nullable();
            $table->string('keaktifan')->nullable();
            $table->string('partisipasi_bos')->nullable();
            $table->string('waktu_penyelenggaraan')->nullable();
            $table->string('akses_internet')->nullable();
            $table->string('akreditasi')->nullable();
            $table->string('angkatan_psp')->nullable();
        
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sekolah');
    }
};
