<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('guru', function (Blueprint $table) {
            $table->id();
            $table->string('nama_guru');
            $table->string('nuptk')->nullable()->unique();
            $table->string('nip')->nullable();
            $table->unsignedBigInteger('bidang_bahasa_id')->nullable();
            $table->unsignedBigInteger('sekolah_id')->nullable();
            $table->string('kab_kota')->nullable();
            $table->string('no_hp')->nullable();
            $table->string('email')->nullable()->unique();
            $table->timestamps();

            $table->foreign('bidang_bahasa_id')->references('id')->on('bidang_bahasa');
            $table->foreign('sekolah_id')->references('id')->on('sekolah');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('guru');
    }
};
