<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('log_sync_dapodik', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('jenis_data'); // sekolah / guru / dll
            $table->integer('jumlah_data_ditarik')->default(0);
            $table->dateTime('waktu_sync');
            $table->string('status')->default('sukses'); // sukses / gagal
            $table->text('keterangan_error')->nullable();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('log_sync_dapodik');
    }
};
