<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('guru', function (Blueprint $table) {
            // NIK – identitas utama
            if (!Schema::hasColumn('guru', 'nik')) {
                $table->string('nik', 20)
                      ->nullable()
                      ->after('id');
                $table->unique('nik');
            }

            // Gelar & identitas lanjutan
            if (!Schema::hasColumn('guru', 'gelar')) {
                $table->string('gelar')->nullable()->after('nama_guru');
            }

            if (!Schema::hasColumn('guru', 'instansi')) {
                $table->string('instansi')->nullable()->after('sekolah_id');
            }

            if (!Schema::hasColumn('guru', 'pangkat_golongan')) {
                $table->string('pangkat_golongan')->nullable()->after('instansi');
            }

            // TTL & agama
            if (!Schema::hasColumn('guru', 'tempat_lahir')) {
                $table->string('tempat_lahir')->nullable()->after('pangkat_golongan');
            }
            if (!Schema::hasColumn('guru', 'tanggal_lahir')) {
                $table->date('tanggal_lahir')->nullable()->after('tempat_lahir');
            }
            if (!Schema::hasColumn('guru', 'agama')) {
                $table->string('agama')->nullable()->after('tanggal_lahir');
            }

            // Kontak (no_hp sudah ada → pakai sebagai no_telp)
            // kalau mau, bisa rename label di form jadi "No. Telp / HP"

            // Alamat
            if (!Schema::hasColumn('guru', 'alamat_instansi')) {
                $table->text('alamat_instansi')->nullable()->after('kab_kota');
            }
            if (!Schema::hasColumn('guru', 'alamat_rumah')) {
                $table->text('alamat_rumah')->nullable()->after('alamat_instansi');
            }

            // Pendidikan & prodi
            if (!Schema::hasColumn('guru', 'pendidikan_terakhir')) {
                $table->string('pendidikan_terakhir')->nullable()->after('alamat_rumah');
            }
            if (!Schema::hasColumn('guru', 'prodi')) {
                $table->string('prodi')->nullable()->after('pendidikan_terakhir');
            }

            // NPWP & no rekening
            if (!Schema::hasColumn('guru', 'npwp')) {
                $table->string('npwp')->nullable()->after('prodi');
            }
            if (!Schema::hasColumn('guru', 'no_rekening')) {
                $table->string('no_rekening')->nullable()->after('npwp');
            }
        });
    }

    public function down(): void
    {
        Schema::table('guru', function (Blueprint $table) {
            //
        });
    }
};
