<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    // public function up()
    // {
    //     Schema::table('guru', function (Blueprint $table) {

    //         // Pastikan dulu kolom yg mirip tidak bentrok
    //         if (!Schema::hasColumn('guru', 'semester')) $table->string('semester')->nullable();
    //         if (!Schema::hasColumn('guru', 'nama_guru')) $table->string('nama')->nullable()->change();
            
    //         $table->string('jenis_kelamin', 20)->nullable();
    //         $table->string('status_kepegawaian', 100)->nullable();
    //         $table->string('jenis_ptk', 150)->nullable();
    //         $table->string('status_keaktifan', 50)->nullable();
    //         $table->string('tmt_pengangkatan')->nullable();
    //         $table->string('lembaga_pengangkat')->nullable();
    //         $table->string('keahlian_laboratorium')->nullable();
    //         $table->string('status_perkawinan')->nullable();
    //         $table->string('sudah_lisensi_kepala_sekolah')->nullable();
    //         $table->string('pernah_diklat_kepengawasan')->nullable();
    //         $table->string('mampu_handle_kk')->nullable();
    //         $table->string('keahlian_braille')->nullable();
    //         $table->string('keahlian_bhs_isyarat')->nullable();
    //         $table->string('ptk_induk')->nullable();
    //         $table->string('jenis_keluar')->nullable();

    //         // Sertifikasi
    //         $table->string('riwayat_sertifikasi_bidang_studi')->nullable();
    //         $table->string('riwayat_sertifikasi_jenis_sertifikasi')->nullable();
    //         $table->string('riwayat_sertifikasi_tahun_sertifikasi')->nullable();
    //         $table->string('riwayat_sertifikasi_nomor_sertifikat')->nullable();
    //         $table->string('riwayat_sertifikasi_nrg')->nullable();

    //         // Riwayat Pendidikan
    //         $table->string('riwayat_pendidikan_formal_bidang_studi')->nullable();
    //         $table->string('riwayat_pendidikan_formal_jenjang_pendidikan')->nullable();

    //         $table->string('jabatan_ptk')->nullable();
    //     });
    // }

    public function up()
    {
        // rename di luar closure lebih aman untuk cek kondisi
        if (Schema::hasColumn('guru', 'nama') && !Schema::hasColumn('guru', 'nama_guru')) {
            Schema::table('guru', function (Blueprint $table) {
                $table->renameColumn('nama', 'nama_guru');
            });
        }

        Schema::table('guru', function (Blueprint $table) {

            // Kolom identitas PTK
            if (!Schema::hasColumn('guru', 'semester')) $table->string('semester')->nullable();

            // Pastikan "nama_guru" ada
            if (!Schema::hasColumn('guru', 'nama_guru')) $table->string('nama_guru')->nullable();

            if (!Schema::hasColumn('guru', 'jenis_kelamin')) $table->string('jenis_kelamin', 20)->nullable();
            if (!Schema::hasColumn('guru', 'status_kepegawaian')) $table->string('status_kepegawaian', 100)->nullable();
            if (!Schema::hasColumn('guru', 'jenis_ptk')) $table->string('jenis_ptk', 150)->nullable();
            if (!Schema::hasColumn('guru', 'status_keaktifan')) $table->string('status_keaktifan', 50)->nullable();
            if (!Schema::hasColumn('guru', 'tmt_pengangkatan')) $table->string('tmt_pengangkatan')->nullable();
            if (!Schema::hasColumn('guru', 'lembaga_pengangkat')) $table->string('lembaga_pengangkat')->nullable();
            if (!Schema::hasColumn('guru', 'keahlian_laboratorium')) $table->string('keahlian_laboratorium')->nullable();
            if (!Schema::hasColumn('guru', 'status_perkawinan')) $table->string('status_perkawinan')->nullable();
            if (!Schema::hasColumn('guru', 'sudah_lisensi_kepala_sekolah')) $table->string('sudah_lisensi_kepala_sekolah')->nullable();
            if (!Schema::hasColumn('guru', 'pernah_diklat_kepengawasan')) $table->string('pernah_diklat_kepengawasan')->nullable();
            if (!Schema::hasColumn('guru', 'mampu_handle_kk')) $table->string('mampu_handle_kk')->nullable();
            if (!Schema::hasColumn('guru', 'keahlian_braille')) $table->string('keahlian_braille')->nullable();
            if (!Schema::hasColumn('guru', 'keahlian_bhs_isyarat')) $table->string('keahlian_bhs_isyarat')->nullable();
            if (!Schema::hasColumn('guru', 'ptk_induk')) $table->string('ptk_induk')->nullable();
            if (!Schema::hasColumn('guru', 'jenis_keluar')) $table->string('jenis_keluar')->nullable();

            // Sertifikasi
            if (!Schema::hasColumn('guru', 'riwayat_sertifikasi_bidang_studi')) $table->string('riwayat_sertifikasi_bidang_studi')->nullable();
            if (!Schema::hasColumn('guru', 'riwayat_sertifikasi_jenis_sertifikasi')) $table->string('riwayat_sertifikasi_jenis_sertifikasi')->nullable();
            if (!Schema::hasColumn('guru', 'riwayat_sertifikasi_tahun_sertifikasi')) $table->string('riwayat_sertifikasi_tahun_sertifikasi')->nullable();
            if (!Schema::hasColumn('guru', 'riwayat_sertifikasi_nomor_sertifikat')) $table->string('riwayat_sertifikasi_nomor_sertifikat')->nullable();
            if (!Schema::hasColumn('guru', 'riwayat_sertifikasi_nrg')) $table->string('riwayat_sertifikasi_nrg')->nullable();

            // Riwayat Pendidikan
            if (!Schema::hasColumn('guru', 'riwayat_pendidikan_formal_bidang_studi')) $table->string('riwayat_pendidikan_formal_bidang_studi')->nullable();
            if (!Schema::hasColumn('guru', 'riwayat_pendidikan_formal_jenjang_pendidikan')) $table->string('riwayat_pendidikan_formal_jenjang_pendidikan')->nullable();

            if (!Schema::hasColumn('guru', 'jabatan_ptk')) $table->string('jabatan_ptk')->nullable();
        });
    }

    public function down()
    {
        Schema::table('guru', function (Blueprint $table) {
            $table->dropColumn([
                'semester','jenis_kelamin','status_kepegawaian','jenis_ptk','status_keaktifan',
                'tmt_pengangkatan','lembaga_pengangkat','keahlian_laboratorium','status_perkawinan',
                'sudah_lisensi_kepala_sekolah','pernah_diklat_kepengawasan','mampu_handle_kk',
                'keahlian_braille','keahlian_bhs_isyarat','ptk_induk','jenis_keluar',
                'riwayat_sertifikasi_bidang_studi','riwayat_sertifikasi_jenis_sertifikasi',
                'riwayat_sertifikasi_tahun_sertifikasi','riwayat_sertifikasi_nomor_sertifikat',
                'riwayat_sertifikasi_nrg','riwayat_pendidikan_formal_bidang_studi',
                'riwayat_pendidikan_formal_jenjang_pendidikan','jabatan_ptk'
            ]);
        });
    }
};
