<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('keuangan_kuitansi', function (Blueprint $table) {
            $table->id();

            $table->foreignId('guru_id')->constrained('guru')->cascadeOnDelete();
            $table->foreignId('pelatihan_id')->nullable()->constrained('pelatihan')->nullOnDelete();

            // ✅ link ke registrasi (buat autofill dari form)
            $table->foreignId('registrasi_peserta_id')
                ->nullable()
                ->constrained('registrasi_peserta')
                ->nullOnDelete();

            $table->string('tahun_anggaran', 4);
            $table->string('bukti_kas_no', 100)->nullable();
            $table->string('beban', 150)->nullable();
            $table->string('akun', 150)->nullable();

            $table->string('sudah_terima_dari')->nullable();
            $table->text('untuk_pembayaran');

            $table->unsignedBigInteger('honor_bruto')->default(0);
            $table->decimal('pph21_rate', 6, 2)->nullable();
            $table->unsignedBigInteger('pph21_amount')->default(0);
            $table->unsignedBigInteger('jumlah_diterima')->default(0);

            $table->date('tanggal_kuitansi')->nullable();
            $table->string('terbilang')->nullable();

            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('keuangan_kuitansi');
    }
};
