<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('keuangan_kuitansi', function (Blueprint $table) {
            $table->bigInteger('honor_jp')->default(0)->after('untuk_pembayaran');

            $table->bigInteger('transport_nominal')->default(0)->after('honor_jp');
            $table->integer('transport_kali')->default(0)->after('transport_nominal');
            $table->bigInteger('transport_total')->default(0)->after('transport_kali');
        });
    }

    public function down()
    {
        Schema::table('keuangan_kuitansi', function (Blueprint $table) {
            $table->dropColumn([
                'honor_jp',
                'transport_nominal',
                'transport_kali',
                'transport_total',
            ]);
        });
    }
};
