<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('registrasi_peserta', function (Blueprint $table) {
            if (!Schema::hasColumn('registrasi_peserta', 'user_id')) {
                $table->unsignedBigInteger('user_id')->nullable()->after('pelatihan_id');
            }
        });

        try {
            $validUserIds = DB::table('users')->pluck('id')->toArray();
            if (!empty($validUserIds)) {
                DB::table('registrasi_peserta')
                    ->whereNotNull('user_id')
                    ->whereNotIn('user_id', $validUserIds)
                    ->update(['user_id' => null]);
            } else {
                DB::table('registrasi_peserta')->update(['user_id' => null]);
            }
        } catch (\Throwable $e) {
        }

        try {
            DB::statement("
                ALTER TABLE registrasi_peserta
                ADD CONSTRAINT registrasi_peserta_user_id_foreign
                FOREIGN KEY (user_id) REFERENCES users(id)
                ON DELETE SET NULL
            ");
        } catch (\Throwable $e) {
        }

        try {
            DB::statement("
                CREATE UNIQUE INDEX uniq_user_pelatihan
                ON registrasi_peserta (user_id, pelatihan_id)
            ");
        } catch (\Throwable $e) {
        }

        try {
            DB::statement("
                CREATE UNIQUE INDEX uniq_nik_pelatihan
                ON registrasi_peserta (nik, pelatihan_id)
            ");
        } catch (\Throwable $e) {
        }
    }

    public function down(): void
    {
        try { DB::statement("DROP INDEX uniq_user_pelatihan ON registrasi_peserta"); } catch (\Throwable $e) {}
        try { DB::statement("DROP INDEX uniq_nik_pelatihan ON registrasi_peserta"); } catch (\Throwable $e) {}
        try { DB::statement("ALTER TABLE registrasi_peserta DROP FOREIGN KEY registrasi_peserta_user_id_foreign"); } catch (\Throwable $e) {}

        Schema::table('registrasi_peserta', function (Blueprint $table) {
            if (Schema::hasColumn('registrasi_peserta', 'user_id')) {
                $table->dropColumn('user_id');
            }
        });
    }
};
