<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pelatihan_kelas_fasil', function (Blueprint $table) {
            $table->id();

            $table->foreignId('pelatihan_kelas_id')
                  ->constrained('pelatihan_kelas')
                  ->cascadeOnDelete();

            $table->string('nama_fasil');
            $table->string('no_telp', 50)->nullable(); 
            $table->string('instansi')->nullable();

            $table->string('hari'); // Senin, Selasa, dst
            $table->date('tanggal');

            $table->time('waktu_mulai');
            $table->time('waktu_selesai');

            $table->integer('jp'); // 1 JP = 45 menit
            $table->string('tempat')->nullable();
            $table->text('keterangan')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pelatihan_kelas_fasil');
    }
};
