<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('daftar_hadir', function (Blueprint $table) {
            $table->foreignId('surat_tugas_id')
                ->after('id')
                ->constrained('surat_tugas')
                ->cascadeOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('daftar_hadir', function (Blueprint $table) {
            $table->dropForeign(['surat_tugas_id']);
            $table->dropColumn('surat_tugas_id');
        });
    }

};
