{{-- resources/views/guru/_form-fields.blade.php --}}

<div class="row g-3">

    {{-- NIK (PRIMARY KEY) --}}
    <div class="col-md-4">
        <label class="form-label small">NIK</label>
        <input type="text" name="nik" value="{{ old('nik', $guru->nik ?? '') }}"
               class="form-control form-control-sm" required>
    </div>

    {{-- Nama Lengkap --}}
    <div class="col-md-4">
        <label class="form-label small">Nama Lengkap</label>
        <input type="text" name="nama_guru" value="{{ old('nama_guru', $guru->nama_guru ?? '') }}"
               class="form-control form-control-sm" required>
    </div>

    {{-- Gelar --}}
    <div class="col-md-4">
        <label class="form-label small">Gelar</label>
        <input type="text" name="gelar" value="{{ old('gelar', $guru->gelar ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- NUPTK --}}
    <div class="col-md-4">
        <label class="form-label small">NUPTK</label>
        <input type="text" name="nuptk" value="{{ old('nuptk', $guru->nuptk ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- NIP --}}
    <div class="col-md-4">
        <label class="form-label small">NIP</label>
        <input type="text" name="nip" value="{{ old('nip', $guru->nip ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- INSTANSI --}}
    <div class="col-md-4">
        <label class="form-label small">Instansi</label>
        <input type="text" name="instansi" value="{{ old('instansi', $guru->instansi ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- SEKOLAH (FK PAKAI id) --}}
    <div class="mb-3">
        <label for="sekolah_id" class="form-label">Sekolah</label>
        <select name="sekolah_id" id="sekolah_id" class="form-control">
            <option value="">Pilih Sekolah</option>
            @foreach($sekolahList as $sekolah)
                <option value="{{ $sekolah->id }}" 
                    {{ old('sekolah_id', $guru->sekolah_id ?? '') == $sekolah->id ? 'selected' : '' }}>
                    {{ $sekolah->nama }} - {{ $sekolah->kabupaten }}
                </option>
            @endforeach
        </select>
        @error('sekolah_id')
            <div class="text-danger small">{{ $message }}</div>
        @enderror
    </div>

    {{-- Pangkat Golongan --}}
    <div class="col-md-6">
        <label class="form-label small">Pangkat / Golongan</label>
        <input type="text" name="pangkat_golongan"
               value="{{ old('pangkat_golongan', $guru->pangkat_golongan ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- Tempat Lahir --}}
    <div class="col-md-4">
        <label class="form-label small">Tempat Lahir</label>
        <input type="text" name="tempat_lahir"
               value="{{ old('tempat_lahir', $guru->tempat_lahir ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- Tanggal Lahir --}}
    <div class="col-md-4">
        <label class="form-label small">Tanggal Lahir</label>
        <input type="date" name="tanggal_lahir"
               value="{{ old('tanggal_lahir', $guru->tanggal_lahir ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- Agama --}}
    <div class="col-md-4">
        <label class="form-label small">Agama</label>
        <select name="agama" class="form-select form-select-sm">
            @foreach(['Islam','Kristen','Katolik','Hindu','Budha','Konghucu'] as $agama)
                <option value="{{ $agama }}"
                    {{ old('agama', $guru->agama ?? '') == $agama ? 'selected' : '' }}>
                    {{ $agama }}
                </option>
            @endforeach
        </select>
    </div>

    {{-- Alamat Instansi --}}
    <div class="col-md-6">
        <label class="form-label small">Alamat Instansi</label>
        <input type="text" name="alamat_instansi"
               value="{{ old('alamat_instansi', $guru->alamat_instansi ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- Alamat Rumah --}}
    <div class="col-md-6">
        <label class="form-label small">Alamat Rumah</label>
        <input type="text" name="alamat_rumah"
               value="{{ old('alamat_rumah', $guru->alamat_rumah ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- No HP --}}
    <div class="col-md-4">
        <label class="form-label small">No HP</label>
        <input type="text" name="no_hp"
               value="{{ old('no_hp', $guru->no_hp ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- Email --}}
    <div class="col-md-4">
        <label class="form-label small">Email</label>
        <input type="email" name="email"
               value="{{ old('email', $guru->email ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- Pendidikan Terakhir --}}
    <div class="col-md-4">
        <label class="form-label small">Pendidikan Terakhir</label>
        <input type="text" name="pendidikan_terakhir"
               value="{{ old('pendidikan_terakhir', $guru->pendidikan_terakhir ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- Prodi --}}
    <div class="col-md-6">
        <label class="form-label small">Prodi</label>
        <input type="text" name="prodi"
               value="{{ old('prodi', $guru->prodi ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- NPWP --}}
    <div class="col-md-3">
        <label class="form-label small">NPWP</label>
        <input type="text" name="npwp"
               value="{{ old('npwp', $guru->npwp ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- No Rekening --}}
    <div class="col-md-3">
        <label class="form-label small">No Rekening</label>
        <input type="text" name="no_rekening"
               value="{{ old('no_rekening', $guru->no_rekening ?? '') }}"
               class="form-control form-control-sm">
    </div>

    {{-- Bidang Bahasa --}}
    <div class="col-md-4">
        <label class="form-label small">Bidang Bahasa</label>
        <select name="bidang_bahasa_id" class="form-select form-select-sm">
            <option value="">-- Pilih Bidang --</option>
            @foreach($bidangList as $bidang)
                <option value="{{ $bidang->id }}"
                    {{ old('bidang_bahasa_id', $guru->bidang_bahasa_id ?? '') == $bidang->id ? 'selected' : '' }}>
                    {{ $bidang->nama_bahasa }}
                </option>
            @endforeach
        </select>
    </div>

</div>
