@extends('layouts.admin')

@section('title', 'Tambah Guru - BGTK DKI')
@section('page_title', 'Tambah Data Guru / PTK')
@section('page_subtitle', 'Lengkapi identitas guru sesuai kebutuhan BGTK DKI Jakarta')

@section('content')

    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('guru.index') }}" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left"></i> Kembali
        </a>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body">

            <form action="{{ route('guru.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                {{-- FOTO PROFIL --}}
                <div class="row mb-4">
                    <div class="col-md-3 mx-auto text-center">
                        <img src="{{ asset('images/default-profile.png') }}" id="previewFoto" class="rounded shadow-sm mb-2"
                            style="width: 170px; height: 210px; object-fit: cover;">

                        <div class="mt-2">
                            <label class="form-label small fw-semibold">
                                Foto Guru (opsional)
                            </label>
                            <input type="file" name="foto" class="form-control form-control-sm" accept="image/*"
                                onchange="previewImage(this)">
                            <small class="text-muted d-block">
                                JPG / PNG • Maks 2MB
                            </small>
                        </div>
                    </div>
                </div>

                {{-- FORM DATA --}}
                <div class="row g-3">

                    {{-- Nama Guru --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Nama Guru</label>
                        <input type="text" name="nama_guru"
                            class="form-control form-control-sm @error('nama_guru') is-invalid @enderror"
                            value="{{ old('nama_guru') }}" required>
                        @error('nama_guru')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- NIP --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">NIP</label>
                        <input type="text" name="nip" class="form-control form-control-sm" value="{{ old('nip') }}">
                    </div>

                    {{-- NUPTK --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">NUPTK</label>
                        <input type="text" name="nuptk" class="form-control form-control-sm" value="{{ old('nuptk') }}">
                    </div>

                    {{-- NIK --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">NIK</label>
                        <input type="text" name="nik"
                            class="form-control form-control-sm @error('nik') is-invalid @enderror" value="{{ old('nik') }}"
                            required>
                        @error('nik')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Sekolah --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Sekolah</label>
                        <select name="sekolah_id" id="sekolah_id"
                            class="form-select form-select-sm @error('sekolah_id') is-invalid @enderror">
                            <option value="" selected disabled>Pilih Sekolah</option>
                            @foreach($sekolahList as $s)
                                <option value="{{ $s->id }}">
                                    {{ $s->nama }} - {{ $s->kabupaten }}
                                </option>
                            @endforeach
                        </select>
                        @error('sekolah_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Tempat Lahir --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Tempat Lahir</label>
                        <input type="text" name="tempat_lahir" class="form-control form-control-sm"
                            value="{{ old('tempat_lahir') }}">
                    </div>

                    {{-- Tanggal Lahir --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Tanggal Lahir</label>
                        <input type="date" name="tanggal_lahir" class="form-control form-control-sm"
                            value="{{ old('tanggal_lahir') }}">
                    </div>

                    {{-- Agama --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Agama</label>
                        @php
                            $agamaList = ['Islam', 'Kristen', 'Katholik', 'Hindu', 'Budha', 'Konghucu', 'Lainnya'];
                        @endphp
                        <select name="agama" class="form-select form-select-sm">
                            <option value="">Pilih Agama</option>
                            @foreach($agamaList as $ag)
                                <option value="{{ $ag }}" {{ old('agama') == $ag ? 'selected' : '' }}>
                                    {{ $ag }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Email --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Email</label>
                        <input type="email" name="email" class="form-control form-control-sm" value="{{ old('email') }}">
                    </div>

                    {{-- Pangkat --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Pangkat / Golongan</label>
                        <input type="text" name="pangkat_golongan" class="form-control form-control-sm"
                            value="{{ old('pangkat_golongan') }}">
                    </div>

                    {{-- Instansi --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Instansi</label>
                        <input type="text" name="instansi" class="form-control form-control-sm"
                            value="{{ old('instansi') }}">
                    </div>

                    {{-- Jabatan --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Jabatan</label>
                        <input type="text" name="jabatan" class="form-control form-control-sm" value="{{ old('jabatan') }}">
                    </div>

                    {{-- Kab/Kota --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Kabupaten / Kota</label>
                        <input type="text" name="kab_kota" class="form-control form-control-sm"
                            value="{{ old('kab_kota') }}">
                    </div>

                    {{-- Provinsi --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Provinsi</label>
                        <input type="text" name="provinsi" class="form-control form-control-sm"
                            value="{{ old('provinsi') }}">
                    </div>

                    {{-- No HP --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">No. HP</label>
                        <input type="text" name="no_hp" class="form-control form-control-sm" value="{{ old('no_hp') }}">
                    </div>

                </div>

                <div class="mt-4 text-end">
                    <button type="submit" class="btn btn-primary btn-sm">
                        <i class="bi bi-save me-1"></i> Simpan
                    </button>
                </div>

            </form>
        </div>
    </div>

@endsection

@push('scripts')
    <script>
        function previewImage(input) {
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    document.getElementById('previewFoto').src = e.target.result;
                };
                reader.readAsDataURL(input.files[0]);
            }
        }

        $(function () {
            $('#sekolah_id').select2({
                placeholder: "Cari berdasarkan nama / kabupaten",
                width: '100%'
            });
        });
    </script>
@endpush