@extends('layouts.admin')

@section('content')
<div class="container py-3">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <div>
      <h5 class="mb-0 fw-bold">Tambah Jadwal</h5>
      <small class="text-muted">
        {{ $kelas->pelatihan->nama_pelatihan }} ({{ $kelas->nama_kelas }})
      </small>
    </div>

    <a href="{{ route('admin.kelas.jadwal.index', $kelas->id) }}" class="btn btn-outline-secondary">
      Kembali
    </a>
  </div>

  <div class="card">
    <div class="card-header fw-bold">
      Form Jadwal Kelas
    </div>

    <div class="card-body">

      @if ($errors->any())
        <div class="alert alert-danger">
          <div class="fw-bold mb-1">Ada data yang belum benar:</div>
          <ul class="mb-0">
            @foreach ($errors->all() as $e)
              <li>{{ $e }}</li>
            @endforeach
          </ul>
        </div>
      @endif

      <form method="POST" action="{{ route('admin.kelas.jadwal.store', $kelas->id) }}">
        @csrf

        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">Tanggal</label>
            <input
              type="date"
              name="tanggal"
              class="form-control"
              required
              value="{{ old('tanggal') }}"
            >
          </div>

          <div class="col-md-4">
            <label class="form-label">Jam Mulai</label>
            <input
              type="time"
              name="jam_mulai"
              class="form-control"
              required
              value="{{ old('jam_mulai') }}"
            >
          </div>

          <div class="col-md-4">
            <label class="form-label">Jam Selesai</label>
            <input
              type="time"
              name="jam_selesai"
              class="form-control"
              required
              value="{{ old('jam_selesai') }}"
            >
          </div>

          <div class="col-md-6">
            <label class="form-label">Mapel</label>
            <input
              type="text"
              name="mapel"
              class="form-control"
              required
              value="{{ old('mapel') }}"
              placeholder="Contoh: Matematika / IPA / BK"
            >
          </div>

          <div class="col-md-6">
            <label class="form-label">Tempat (opsional)</label>
            <input
              type="text"
              name="tempat"
              class="form-control"
              value="{{ old('tempat') }}"
              placeholder="Contoh: Lab BGTK DKI"
            >
          </div>

          <div class="col-md-6">
            <label class="form-label">Ishoma Mulai (opsional)</label>
            <input
              type="time"
              name="ishoma_mulai"
              class="form-control"
              value="{{ old('ishoma_mulai') }}"
            >
          </div>

          <div class="col-md-6">
            <label class="form-label">Ishoma Selesai (opsional)</label>
            <input
              type="time"
              name="ishoma_selesai"
              class="form-control"
              value="{{ old('ishoma_selesai') }}"
            >
          </div>
        </div>

        <div class="d-flex justify-content-end mt-4">
          <a href="{{ route('admin.kelas.jadwal.index', $kelas->id) }}" class="btn btn-light me-2">
            Batal
          </a>
          <button type="submit" class="btn btn-primary">
            Simpan Jadwal
          </button>
        </div>

      </form>
    </div>
  </div>
</div>
@endsection
