@extends('layouts.admin')

@section('page_title','Buat Daftar Hadir')

@section('content')
<div class="card">
    <div class="card-body">

        <form method="POST" action="{{ route('daftar-hadir.store') }}">
            @csrf

            {{-- SURAT TUGAS --}}
            <div class="mb-3">
                <label class="form-label fw-semibold">Surat Tugas</label>
                <select name="surat_tugas_id"
                        class="form-select @error('surat_tugas_id') is-invalid @enderror"
                        required>
                    <option value="">-- Pilih Surat Tugas --</option>
                    @foreach($suratTugas as $st)
                        <option value="{{ $st->id }}">
                            {{ $st->nama_kegiatan }}
                            ({{ $st->pegawais_count }} pegawai)
                        </option>
                    @endforeach
                </select>
                @error('surat_tugas_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            {{-- TANGGAL & TEMPAT --}}
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Tanggal</label>
                    <input type="date"
                           name="tanggal"
                           class="form-control"
                           value="{{ old('tanggal') }}"
                           required>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Tempat</label>
                    <input type="text"
                           name="tempat"
                           class="form-control"
                           value="{{ old('tempat') }}"
                           required>
                </div>
            </div>

            <hr>

            {{-- INFO --}}
            <div class="alert alert-info small">
                Peserta dari Surat Tugas akan otomatis masuk ke daftar hadir.
            </div>

            {{-- PESERTA MANUAL --}}
            <h6 class="fw-bold mb-2">Peserta Manual (Opsional)</h6>

            <div id="manual-wrapper"></div>

            <button type="button"
                    id="btn-add"
                    class="btn btn-sm btn-outline-primary mb-4">
                <i class="bi bi-plus-circle"></i> Tambah Peserta Manual
            </button>

            {{-- ACTION --}}
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">
                    Simpan Daftar Hadir
                </button>

                <a href="{{ route('daftar-hadir.index') }}"
                   class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {

    const wrapper = document.getElementById('manual-wrapper');
    const btnAdd  = document.getElementById('btn-add');

    btnAdd.addEventListener('click', function () {

        const row = document.createElement('div');
        row.classList.add('input-group','mb-2','manual-row');

        row.innerHTML = `
            <input type="text"
                   name="manual_new[]"
                   class="form-control"
                   placeholder="Nama peserta manual"
                   required>

            <button type="button"
                    class="btn btn-outline-danger btn-remove">
                <i class="bi bi-trash"></i>
            </button>
        `;

        wrapper.appendChild(row);
    });

    wrapper.addEventListener('click', function (e) {
        if (e.target.closest('.btn-remove')) {
            e.target.closest('.manual-row').remove();
        }
    });

});
</script>
@endpush
