@extends('layouts.admin')

@section('page_title','Daftar Hadir Narasumber')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">
            Daftar Hadir Narasumber<br>
            <small class="text-muted">
                {{ $daftarHadir->suratTugas->nama_kegiatan }}
            </small>
        </h5>

        <a href="{{ route('daftar-hadir-narasumber.create', $daftarHadir->id) }}"
           class="btn btn-success btn-sm">
            <i class="bi bi-plus-circle"></i> Tambah Narasumber
        </a>
    </div>

    <div class="card-body">
        <table class="table table-bordered table-striped">
            <thead class="table-light">
                <tr>
                    <th width="40">No</th>
                    <th>Nama Narasumber</th>
                    <th width="160">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @forelse($daftarHadir->detail as $i => $row)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td>{{ $row->nama_manual }}</td>
                    <td class="text-center">
                        <div class="btn-group btn-group-sm">
                            <a href="{{ route('daftar-hadir-narasumber.edit', $daftarHadir->id) }}"
                               class="btn btn-warning">
                                <i class="bi bi-pencil-square"></i>
                            </a>

                            <form action="{{ route('daftar-hadir-narasumber.destroy', $daftarHadir->id) }}"
                                  method="POST"
                                  onsubmit="return confirm('Yakin hapus semua narasumber?')">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="3" class="text-center text-muted">
                        Belum ada narasumber
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>

        <div class="mt-3">
            <a href="{{ route('daftar-hadir.index') }}"
               class="btn btn-secondary btn-sm">
                Kembali
            </a>

            <a href="{{ route('daftar-hadir-narasumber.cetak', $daftarHadir->id) }}"
               target="_blank"
               class="btn btn-primary btn-sm">
                <i class="bi bi-printer"></i> Cetak
            </a>
        </div>
    </div>
</div>
@endsection
