@extends('layouts.admin')

@section('page_title','Tambah Narasumber')

@section('content')
<div class="card">
    <div class="card-body">

        <h6 class="fw-bold mb-3">
            {{ $daftarHadir->suratTugas->nama_kegiatan }}
        </h6>

        <form method="POST"
              action="{{ route('daftar-hadir-narasumber.store', $daftarHadir->id) }}">
            @csrf

            <div class="alert alert-info small">
                Semua narasumber diinput secara manual.
            </div>

            {{-- INPUT DINAMIS --}}
            <div id="narasumber-wrapper">

                <div class="input-group mb-2 narasumber-row">
                    <input type="text"
                           name="nama_manual[]"
                           class="form-control"
                           placeholder="Nama narasumber"
                           required>

                    <button type="button"
                            class="btn btn-outline-danger btn-remove">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>

            </div>

            <button type="button"
                    id="btn-add"
                    class="btn btn-sm btn-outline-primary mb-4">
                <i class="bi bi-plus-circle"></i> Tambah Narasumber
            </button>

            {{-- ACTION --}}
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">
                    Simpan Narasumber
                </button>

                <a href="{{ route('daftar-hadir.index') }}"
                   class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {

    const wrapper = document.getElementById('narasumber-wrapper');
    const btnAdd = document.getElementById('btn-add');

    btnAdd.addEventListener('click', function () {
        const row = document.createElement('div');
        row.classList.add('input-group','mb-2','narasumber-row');

        row.innerHTML = `
            <input type="text"
                   name="nama_manual[]"
                   class="form-control"
                   placeholder="Nama narasumber"
                   required>

            <button type="button"
                    class="btn btn-outline-danger btn-remove">
                <i class="bi bi-trash"></i>
            </button>
        `;

        wrapper.appendChild(row);
    });

    wrapper.addEventListener('click', function (e) {
        if (e.target.closest('.btn-remove')) {
            e.target.closest('.narasumber-row').remove();
        }
    });

});
</script>
@endpush
