@extends('layouts.admin')

@section('page_title','Kelola Narasumber')

@section('content')
<div class="card">
    <div class="card-body">

        <h6 class="fw-bold mb-3">
            {{ $daftarHadir->suratTugas->nama_kegiatan }}
        </h6>

        <form method="POST"
              action="{{ route('daftar-hadir-narasumber.update', $daftarHadir->id) }}">
            @csrf
            @method('PUT')

            {{-- NARASUMBER EXISTING --}}
            <h6 class="fw-semibold mb-2">Daftar Narasumber</h6>

            <div id="existing-wrapper">
                @forelse($daftarHadir->detail as $row)
                <div class="input-group mb-2 narasumber-row">
                    <input type="text"
                           name="manual_existing[{{ $row->id }}]"
                           class="form-control"
                           value="{{ $row->nama_manual }}"
                           required>

                    <button type="button"
                            class="btn btn-outline-danger btn-remove-existing"
                            data-id="{{ $row->id }}">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
                @empty
                <div class="text-muted small mb-2">
                    Belum ada narasumber
                </div>
                @endforelse
            </div>

            <hr>

            {{-- NARASUMBER BARU --}}
            <h6 class="fw-semibold mb-2">Tambah Narasumber Baru</h6>

            <div id="new-wrapper"></div>

            <button type="button"
                    id="btn-add"
                    class="btn btn-sm btn-outline-primary mb-4">
                <i class="bi bi-plus-circle"></i> Tambah Narasumber
            </button>

            {{-- ACTION --}}
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">
                    Simpan Perubahan
                </button>

                <a href="{{ route('daftar-hadir.index') }}"
                   class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {

    const newWrapper = document.getElementById('new-wrapper');
    const btnAdd = document.getElementById('btn-add');
    const existingWrapper = document.getElementById('existing-wrapper');

    // tambah narasumber baru
    btnAdd.addEventListener('click', function () {
        const row = document.createElement('div');
        row.classList.add('input-group','mb-2','narasumber-new');

        row.innerHTML = `
            <input type="text"
                   name="manual_new[]"
                   class="form-control"
                   placeholder="Nama narasumber"
                   required>

            <button type="button"
                    class="btn btn-outline-danger btn-remove-new">
                <i class="bi bi-trash"></i>
            </button>
        `;

        newWrapper.appendChild(row);
    });

    // hapus input baru
    newWrapper.addEventListener('click', function (e) {
        if (e.target.closest('.btn-remove-new')) {
            e.target.closest('.narasumber-new').remove();
        }
    });

    // hapus existing (langsung dari UI)
    existingWrapper.addEventListener('click', function (e) {
        if (e.target.closest('.btn-remove-existing')) {
            e.target.closest('.narasumber-row').remove();
        }
    });

});
</script>
@endpush
