@extends('layouts.admin')

@section('page_title','Buat SK Kegiatan')

@section('content')
<div class="card">
    <div class="card-body">

        <form action="{{ route('sk.store') }}" method="POST">
            @csrf

            {{-- Nama Kegiatan --}}
            <div class="mb-3">
                <label class="form-label fw-semibold">Nama Kegiatan</label>
                <input type="text"
                       name="nama_kegiatan"
                       class="form-control"
                       required
                       value="{{ old('nama_kegiatan') }}">
            </div>

            {{-- Nomor SK --}}
            <div class="mb-3">
                <label class="form-label">Nomor SK</label>
                <input type="text"
                       name="nomor_sk"
                       class="form-control"
                       required
                       value="{{ old('nomor_sk') }}">
            </div>

            {{-- Tanggal SK --}}
            <div class="mb-3">
                <label class="form-label">Tanggal SK</label>
                <input type="date"
                       name="tanggal_sk"
                       class="form-control"
                       required
                       value="{{ old('tanggal_sk') }}">
            </div>

            {{-- Pejabat Penandatangan --}}
            <div class="mb-3">
                <label class="form-label">Pejabat Penandatangan</label>
                <input type="text"
                       name="pejabat_penandatangan"
                       class="form-control"
                       required
                       value="{{ old('pejabat_penandatangan') }}">
            </div>

            {{-- NIP Penandatangan --}}
            <div class="mb-3">
                <label class="form-label">NIP Penandatangan</label>
                <input type="text"
                       name="nip_penandatangan"
                       class="form-control"
                       value="{{ old('nip_penandatangan') }}">
            </div>

            {{-- Jabatan Penandatangan --}}
            <div class="mb-4">
                <label class="form-label">Jabatan Penandatangan</label>
                <input type="text"
                       name="jabatan_penandatangan"
                       class="form-control"
                       required
                       value="{{ old('jabatan_penandatangan') }}">
            </div>

            <hr>

            {{-- Anggota SK --}}
            <div class="mb-3">
                <label class="form-label fw-semibold">Anggota SK</label>

                <div class="card">
                    <div class="card-body" style="max-height: 350px; overflow-y: auto">

                        @forelse($pegawais as $jabatan => $items)
                            @php
                                $groupClass = \Illuminate\Support\Str::slug($jabatan ?? 'tanpa-jabatan');
                            @endphp

                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <strong>{{ $jabatan ?? 'Tanpa Jabatan' }}</strong>

                                    <div class="form-check">
                                        <input type="checkbox"
                                               class="form-check-input select-all"
                                               data-group="{{ $groupClass }}"
                                               id="select-all-{{ $groupClass }}">
                                        <label class="form-check-label small"
                                               for="select-all-{{ $groupClass }}">
                                            Pilih Semua
                                        </label>
                                    </div>
                                </div>

                                <hr class="my-2">

                                @foreach($items as $pegawai)
                                    <div class="form-check ms-3 mb-1">
                                        <input class="form-check-input pegawai-checkbox {{ $groupClass }}"
                                               type="checkbox"
                                               name="anggota[]"
                                               value="{{ $pegawai->id }}"
                                               id="pegawai-{{ $pegawai->id }}">

                                        <label class="form-check-label"
                                               for="pegawai-{{ $pegawai->id }}">
                                            {{ $pegawai->nama }}
                                            <small class="text-muted">
                                                ({{ $pegawai->nip ?? '-' }})
                                            </small>
                                        </label>
                                    </div>
                                @endforeach
                            </div>
                        @empty
                            <p class="text-muted mb-0">Data pegawai belum tersedia.</p>
                        @endforelse

                    </div>
                </div>
            </div>

            {{-- Tombol --}}
            <div class="mt-4">
                <button type="submit" class="btn btn-success">
                    Simpan SK
                </button>
                <a href="{{ route('sk.index') }}" class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
@endsection

@push('scripts')
<script>
document.querySelectorAll('.select-all').forEach(cb => {
    cb.addEventListener('change', function () {
        document.querySelectorAll('.' + this.dataset.group)
            .forEach(el => el.checked = this.checked);
    });
});
</script>
@endpush
