@extends('layouts.admin')

@section('page_title','SK Kegiatan')

@section('content')
<div class="card">
    <div class="card-body">

        <a href="{{ route('sk.create') }}" class="btn btn-primary mb-3">
            + Buat SK Kegiatan
        </a>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nomor SK</th>
                    <th>Nama Kegiatan</th>
                    <th>Tanggal SK</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach($data as $i => $row)
                <tr>
                    <td>{{ $i+1 }}</td>
                    <td>{{ $row->nomor_sk }}</td>
                    <td>{{ $row->nama_kegiatan }}</td>
                    <td>{{ $row->tanggal_sk }}</td>
                    <td class="text-center">
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                data-bs-toggle="dropdown"
                                aria-expanded="false">
                            <i class="bi bi-three-dots-vertical"></i>
                        </button>

                        <ul class="dropdown-menu dropdown-menu-end small shadow">

                            {{-- Lihat / Cetak SK --}}
                            <li>
                                <a class="dropdown-item"
                                href="{{ route('sk.cetak', $row->id) }}"
                                target="_blank">
                                    <i class="bi bi-eye me-2 text-primary"></i> Lihat SK
                                </a>
                            </li>

                            <li><hr class="dropdown-divider"></li>

                            {{-- Edit --}}
                            <li>
                                <a class="dropdown-item"
                                href="{{ route('sk.edit', $row->id) }}">
                                    <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                </a>
                            </li>

                            {{-- Hapus --}}
                            <li>
                                <form action="{{ route('sk.destroy', $row->id) }}"
                                    method="POST"
                                    onsubmit="return confirm('Yakin ingin menghapus SK ini?');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger">
                                        <i class="bi bi-trash me-2"></i> Hapus
                                    </button>
                                </form>
                            </li>
                            </ul>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

    </div>
</div>
@endsection
