@extends('layouts.admin')

@section('page_title','Surat Tugas')

@section('content')
<div class="card">
    <div class="card-body">

        <a href="{{ route('surat-tugas.create') }}" class="btn btn-primary mb-3">
            + Buat Surat Tugas
        </a>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nomor Surat</th>
                    <th>Kegiatan</th>
                    <th>Tanggal</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach($data as $i => $row)
                <tr>
                    <td>{{ $i+1 }}</td>
                    <td>{{ $row->nomor_surat }}</td>
                    <td>{{ $row->nama_kegiatan }}</td>
                    <td>{{ $row->tanggal_surat }}</td>
                    <td class="text-center">
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                data-bs-toggle="dropdown">
                            <i class="bi bi-three-dots-vertical"></i>
                        </button>

                        <ul class="dropdown-menu dropdown-menu-end small shadow">

                            {{-- Lihat / Cetak --}}
                            <li>
                                <a class="dropdown-item"
                                href="{{ route('surat-tugas.cetak', $row->id) }}"
                                target="_blank">
                                    <i class="bi bi-eye me-2 text-primary"></i> Lihat Surat
                                </a>
                            </li>

                            <li><hr class="dropdown-divider"></li>

                            {{-- Edit --}}
                            <li>
                                <a class="dropdown-item"
                                href="{{ route('surat-tugas.edit', $row->id) }}">
                                    <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                </a>
                            </li>

                            {{-- Hapus --}}
                            <li>
                                <form action="{{ route('surat-tugas.destroy', $row->id) }}"
                                    method="POST"
                                    onsubmit="return confirm('Yakin ingin menghapus Surat Tugas ini?');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger">
                                        <i class="bi bi-trash me-2"></i> Hapus
                                    </button>
                                </form>
                            </li>

                        </ul>
                    </div>
                </td>

                </tr>
                @endforeach
            </tbody>
        </table>

    </div>
</div>
@endsection
