@extends('layouts.admin')

@section('title', 'Kelas Pelatihan - BGTK DKI')
@section('page_title', 'Kelas Pelatihan')
@section('page_subtitle', 'Daftar semua kelas (A/B/C/D) dari setiap pelatihan')

@section('breadcrumbs')
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
        <li class="breadcrumb-item active" aria-current="page">Kelas Pelatihan</li>
    </ol>
@endsection

@section('content')

    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.kelas.index') }}" class="row g-2 align-items-end">
                <div class="col-12 col-md-5">
                    <label class="form-label form-label-sm mb-1 small">Filter Pelatihan</label>
                    <select name="pelatihan_id" class="form-select form-select-sm js-select2">
                        <option value="">Semua pelatihan</option>
                        @foreach($pelatihanList as $p)
                            <option value="{{ $p->id }}" {{ (string)($pelatihanId ?? '') === (string)$p->id ? 'selected' : '' }}>
                                {{ $p->nama_pelatihan }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-12 col-md-5">
                    <label class="form-label form-label-sm mb-1 small">Pencarian</label>
                    <input type="text" name="search" value="{{ $search ?? '' }}" class="form-control form-control-sm" placeholder="Cari nama kelas / kode / pelatihan">
                </div>

                <div class="col-12 col-md-2 d-flex gap-2">
                    <button class="btn btn-dark btn-sm w-100" type="submit">
                        <i class="bi bi-search me-1"></i> Terapkan
                    </button>
                    <a href="{{ route('admin.kelas.index') }}" class="btn btn-outline-secondary btn-sm d-none d-md-inline-flex">Reset</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Daftar Kelas</h6>
                <small class="text-muted">Menampilkan {{ $kelas->total() }} data</small>
            </div>

            <div class="table-responsive">
                <table class="table table-sm table-hover align-middle">
                    <thead class="table-light small text-uppercase">
                        <tr>
                            <th>Pelatihan</th>
                            <th class="text-center" style="width: 90px;">Kelas</th>
                            <th class="text-center" style="width: 120px;">Peserta</th>
                            <th>Admin LMS</th>
                            <th>Fasil</th>
                            <th class="text-center" style="width: 90px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="small">
                        @forelse($kelas as $k)
                            <tr>
                                <td>
                                    <div class="fw-semibold">{{ $k->pelatihan->nama_pelatihan ?? '-' }}</div>
                                    <div class="text-muted">{{ $k->pelatihan->kategori ?? '-' }}</div>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-primary-subtle text-primary">{{ $k->kode_kelas }}</span>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-secondary-subtle text-secondary">{{ $k->peserta_count }} peserta</span>
                                </td>
                                <td>{{ $k->adminLms->name ?? '-' }}</td>
                                <td>{{ $k->fasil->name ?? '-' }}</td>
                                <td class="text-center">
                                    <a href="{{ route('admin.kelas.show', $k) }}" class="btn btn-outline-primary btn-sm">
                                        <i class="bi bi-gear"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted py-3">Belum ada data kelas.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $kelas->withQueryString()->links() }}
            </div>
        </div>
    </div>

@endsection

@push('scripts')
<script>
    (function () {
        if (!window.jQuery) return;
        $('.js-select2').select2({ theme: 'bootstrap-5', width: '100%' });
    })();
</script>
@endpush
