@extends('layouts.admin')

@section('title', 'Edit Rincian SPD')
@section('page_title', 'Edit Rincian SPD')
@section('page_subtitle', 'Ubah rincian biaya perjalanan dinas')

@section('content')

    @if($errors->any())
        <div class="alert alert-danger small">
            <strong>Terjadi kesalahan:</strong>
            <ul class="mb-0 mt-1">
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.keuangan.spd.update', $spd->id) }}" method="POST">
        @csrf
        @method('PUT')

        {{-- ================= INFORMASI UMUM ================= --}}
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-body">
                <h6 class="mb-3">Informasi Umum</h6>

                <div class="row g-3">

                    {{-- PTK --}}
                    {{-- PTK (readonly tapi tetap terkirim) --}}
                    <div class="col-md-4">
                        <label class="form-label">PTK / Guru</label>

                        <select class="form-select form-select-sm" disabled>
                            <option>
                                {{ $spd->ptk?->nama_guru ?? $spd->ptk?->nama ?? $spd->nama_ptk }}
                                @if($spd->nip_ptk) - ({{ $spd->nip_ptk }}) @endif
                            </option>
                        </select>

                        {{-- INI KUNCI --}}
                        <input type="hidden" name="ptk"
                            value="{{ strtolower(class_basename($spd->ptk_type)) . '_' . $spd->ptk_id }}">

                        <small class="text-muted">PTK tidak dapat diubah</small>
                    </div>


                    {{-- Pelatihan --}}
                    <div class="col-md-4">
                        <label class="form-label small">Pelatihan</label>
                        <select name="pelatihan_id" class="form-select form-select-sm">
                            <option value="">-- opsional --</option>
                            @foreach($pelatihanList as $p)
                                <option value="{{ $p->id }}"
                                    {{ old('pelatihan_id', $spd->pelatihan_id) == $p->id ? 'selected' : '' }}>
                                    {{ $p->nama_pelatihan }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Tahun --}}
                    <div class="col-md-2">
                        <label class="form-label small">Tahun Anggaran</label>
                        <input type="text" name="tahun_anggaran"
                            value="{{ old('tahun_anggaran', $spd->tahun_anggaran) }}"
                            class="form-control form-control-sm" required>
                    </div>

                    {{-- Tanggal --}}
                    <div class="col-md-2">
                        <label class="form-label small">Tanggal SPD</label>
                        <input type="date" name="tanggal_spd"
                            value="{{ old('tanggal_spd', optional($spd->tanggal_spd)->format('Y-m-d')) }}"
                            class="form-control form-control-sm">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label small">Beban MAK</label>
                        <input type="text" name="beban_mak"
                            value="{{ old('beban_mak', $spd->beban_mak) }}"
                            class="form-control form-control-sm">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label small">Bukti Kas No.</label>
                        <input type="text" name="bukti_kas_no"
                            value="{{ old('bukti_kas_no', $spd->bukti_kas_no) }}"
                            class="form-control form-control-sm">
                    </div>

                    <div class="col-md-2">
                        <label class="form-label small">Lampiran SPD</label>
                        <input type="text" name="lampiran_spd"
                            value="{{ old('lampiran_spd', $spd->lampiran_spd) }}"
                            class="form-control form-control-sm">
                    </div>

                    <div class="col-md-2">
                        <label class="form-label small">Nomor SPD</label>
                        <input type="text" name="nomor_spd"
                            value="{{ old('nomor_spd', $spd->nomor_spd) }}"
                            class="form-control form-control-sm">
                    </div>

                </div>
            </div>
        </div>

        {{-- ================= RINCIAN BIAYA ================= --}}
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h6 class="mb-0">Rincian Biaya</h6>
                    <button type="button" class="btn btn-outline-primary btn-sm" id="btnAddRow">
                        <i class="bi bi-plus-lg me-1"></i> Tambah Baris
                    </button>
                </div>

                <div class="table-responsive">
                    <table class="table table-sm align-middle" id="tblItems">
                        <thead class="table-light small text-uppercase">
                            <tr>
                                <th style="width:35%">Perincian Biaya</th>
                                <th style="width:10%">Qty</th>
                                <th style="width:20%">Harga Satuan</th>
                                <th style="width:20%">Keterangan</th>
                                <th style="width:5%"></th>
                            </tr>
                        </thead>
                        <tbody class="small">
                            @foreach(old('uraian', $spd->items ?? []) as $i => $item)
                                <tr>
                                    <td>
                                        <textarea name="uraian[]" rows="3"
                                            class="form-control form-control-sm">{{ is_array($item) ? $item['uraian'] : $item }}</textarea>
                                    </td>
                                    <td>
                                        <input type="number" name="qty[]"
                                            value="{{ old('qty.' . $i, $item['qty'] ?? 1) }}"
                                            class="form-control form-control-sm">
                                    </td>
                                    <td>
                                        <input type="number" name="harga_satuan[]"
                                            value="{{ old('harga_satuan.' . $i, $item['harga_satuan'] ?? 0) }}"
                                            class="form-control form-control-sm">
                                    </td>
                                    <td>
                                        <input type="text" name="keterangan_item[]"
                                            value="{{ old('keterangan_item.' . $i, $item['keterangan'] ?? '') }}"
                                            class="form-control form-control-sm">
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-outline-danger btn-sm btn-remove-row">
                                            <i class="bi bi-x-lg"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <small class="text-muted">Baris kosong akan diabaikan</small>
            </div>
        </div>

        {{-- ================= ACTION ================= --}}
        <div class="d-flex justify-content-between">
            <a href="{{ route('admin.keuangan.spd.index') }}" class="btn btn-outline-secondary">
                Kembali
            </a>
            <button type="submit" class="btn btn-primary">
                Update Rincian SPD
            </button>
        </div>

    </form>

    {{-- TEMPLATE BARIS --}}
    <template id="tpl-row">
        <tr>
            <td><textarea name="uraian[]" rows="3" class="form-control form-control-sm"></textarea></td>
            <td><input type="number" name="qty[]" value="1" class="form-control form-control-sm"></td>
            <td><input type="number" name="harga_satuan[]" value="0" class="form-control form-control-sm"></td>
            <td><input type="text" name="keterangan_item[]" class="form-control form-control-sm"></td>
            <td class="text-center">
                <button type="button" class="btn btn-outline-danger btn-sm btn-remove-row">
                    <i class="bi bi-x-lg"></i>
                </button>
            </td>
        </tr>
    </template>

@endsection

@push('scripts')
<script>
    $('#btnAddRow').on('click', function () {
        $('#tblItems tbody').append($('#tpl-row').html());
    });

    $(document).on('click', '.btn-remove-row', function () {
        $(this).closest('tr').remove();
    });
</script>
@endpush
