@extends('layouts.admin')

@section('title', 'Edit Pegawai - BGTK DKI')
@section('page_title', 'Edit Data Pegawai')
@section('page_subtitle', 'Perbarui data pegawai sesuai kebutuhan BGTK DKI Jakarta')

@section('content')
<div class="container-fluid">

    {{-- Tombol Kembali --}}
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h6 class="mb-0 text-muted">Form Edit Data Pegawai</h6>
        <a href="{{ route('pegawai.index') }}" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left"></i> Kembali
        </a>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body p-4">

            <form action="{{ route('pegawai.update', $pegawai->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                {{-- FOTO --}}
                <div class="text-center mb-4">
                    <img src="{{ $pegawai->foto ? asset('storage/'.$pegawai->foto) : asset('images/default-profile.png') }}"
                        class="rounded shadow-sm mb-3"
                        style="width:160px;height:200px;object-fit:cover"
                        id="previewFoto">

                    <div class="mx-auto" style="max-width:260px">
                        <label class="form-label small text-muted">Foto (Opsional)</label>
                        <input type="file" name="foto" class="form-control form-control-sm"
                            accept="image/*" onchange="previewImage(this)">
                    </div>
                </div>

                <hr>

                {{-- DATA UTAMA --}}
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label small">Nama Pegawai</label>
                        <input type="text" name="nama" class="form-control form-control-sm" required
                            value="{{ old('nama', $pegawai->nama) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label small">NIP</label>
                        <input type="text" name="nip" class="form-control form-control-sm"
                            value="{{ old('nip', $pegawai->nip) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label small">Gol</label>
                        <input type="text" name="gol" class="form-control form-control-sm"
                            value="{{ old('gol', $pegawai->gol) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label small">Pangkat / Golongan</label>
                        <input type="text" name="pangkat_golongan" class="form-control form-control-sm"
                            value="{{ old('pangkat_golongan', $pegawai->pangkat_golongan) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label small">Jabatan</label>
                        <input type="text" name="jabatan" class="form-control form-control-sm"
                            value="{{ old('jabatan', $pegawai->jabatan) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label small">Status Kepegawaian</label>
                        <input type="text" name="status_kepegawaian" class="form-control form-control-sm"
                            value="{{ old('status_kepegawaian', $pegawai->status_kepegawaian) }}">
                    </div>
                </div>

                <hr>

                {{-- DATA PRIBADI --}}
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label small">Tanggal Lahir</label>
                        <input type="date" name="tanggal_lahir" class="form-control form-control-sm"
                            value="{{ old('tanggal_lahir', $pegawai->tanggal_lahir) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label small">Jenis Kelamin</label>
                        <select name="jenis_kelamin" class="form-select form-select-sm">
                            <option value="">Pilih</option>
                            <option value="Laki-laki" {{ $pegawai->jenis_kelamin == 'Laki-laki' ? 'selected' : '' }}>Laki-laki</option>
                            <option value="Perempuan" {{ $pegawai->jenis_kelamin == 'Perempuan' ? 'selected' : '' }}>Perempuan</option>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label small">Email</label>
                        <input type="email" name="email" class="form-control form-control-sm"
                            value="{{ old('email', $pegawai->email) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label small">Telepon</label>
                        <input type="text" name="telepon" class="form-control form-control-sm"
                            value="{{ old('telepon', $pegawai->telepon) }}">
                    </div>

                    <div class="col-md-12">
                        <label class="form-label small">Alamat</label>
                        <textarea name="alamat" class="form-control form-control-sm" rows="2">{{ old('alamat', $pegawai->alamat) }}</textarea>
                    </div>
                </div>

                {{-- ACTION --}}
                <div class="mt-4 text-end">
                    <button type="submit" class="btn btn-primary btn-sm px-4">
                        <i class="bi bi-save"></i> Simpan
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function previewImage(input) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = e => document.getElementById('previewFoto').src = e.target.result;
        reader.readAsDataURL(input.files[0]);
    }
}
</script>
@endpush
