@extends('layouts.admin')

@section('title', 'Detail Pegawai')
@section('page_title', 'Biodata Pegawai')
@section('page_subtitle', 'Informasi lengkap data pribadi dan kepegawaian pegawai')

@section('content')

{{-- HEADER --}}
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body d-flex justify-content-between align-items-center">
        <div>
            <h6 class="mb-1">Biodata Pegawai</h6>
            <small class="text-muted">Detail identitas dan data kepegawaian</small>
        </div>

        <div class="d-flex gap-2">
            <a href="{{ route('pegawai.index') }}" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Kembali
            </a>

            <a href="{{ route('pegawai.edit', $pegawai->id) }}" class="btn btn-warning btn-sm">
                <i class="bi bi-pencil-square"></i> Edit
            </a>
        </div>
    </div>
</div>

{{-- BIODATA --}}
<div class="card border-0 shadow-sm">
    <div class="card-body p-4">

        <div class="row g-4">

            {{-- FOTO & IDENTITAS SINGKAT --}}
            <div class="col-md-3 text-center">
                <img
                    src="{{ $pegawai->foto ? asset('storage/' . $pegawai->foto) : asset('images/default-profile.png') }}"
                    class="rounded shadow-sm mb-3"
                    style="width: 170px; height: 210px; object-fit: cover;"
                >

                <h6 class="fw-semibold mb-0">{{ $pegawai->nama }}</h6>
                <small class="text-muted d-block mb-2">
                    {{ $pegawai->jabatan ?? '-' }}
                </small>

                <span class="badge bg-info">
                    {{ $pegawai->status_kepegawaian ?? '-' }}
                </span>
            </div>

            {{-- DETAIL BIODATA --}}
            <div class="col-md-9">

                {{-- IDENTITAS PRIBADI --}}
                <div class="mb-4">
                    <h6 class="fw-semibold mb-3 border-bottom pb-2">
                        Identitas Pribadi
                    </h6>

                    <div class="table-responsive">
                        <table class="table table-sm table-bordered align-middle small mb-0">
                            <tbody>
                                <tr>
                                    <th width="25%">Nama</th>
                                    <td width="25%">{{ $pegawai->nama }}</td>
                                    <th width="25%">NIP</th>
                                    <td width="25%">{{ $pegawai->nip ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Jenis Kelamin</th>
                                    <td>{{ $pegawai->jenis_kelamin ?? '-' }}</td>
                                    <th>Tanggal Lahir</th>
                                    <td>
                                        {{ $pegawai->tanggal_lahir
                                            ? \Carbon\Carbon::parse($pegawai->tanggal_lahir)->format('d-m-Y')
                                            : '-' }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>Email</th>
                                    <td>{{ $pegawai->email ?? '-' }}</td>
                                    <th>No. Telepon</th>
                                    <td>{{ $pegawai->telepon ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Alamat</th>
                                    <td colspan="3">{{ $pegawai->alamat ?? '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                {{-- DATA KEPEGAWAIAN --}}
                <div>
                    <h6 class="fw-semibold mb-3 border-bottom pb-2">
                        Data Kepegawaian
                    </h6>

                    <div class="table-responsive">
                        <table class="table table-sm table-bordered align-middle small mb-0">
                            <tbody>
                                <tr>
                                    <th width="25%">Jabatan</th>
                                    <td width="25%">{{ $pegawai->jabatan ?? '-' }}</td>
                                    <th width="25%">Golongan</th>
                                    <td width="25%">{{ $pegawai->gol ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Pangkat / Golongan</th>
                                    <td>{{ $pegawai->pangkat_golongan ?? '-' }}</td>
                                    <th>Status Kepegawaian</th>
                                    <td>{{ $pegawai->status_kepegawaian ?? '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>

    </div>
</div>

@endsection
