<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                    Peserta Pelatihan: {{ $pelatihan->nama_pelatihan }}
                </h2>
                <p class="text-xs text-gray-500">
                    Kategori: {{ $pelatihan->kategori ?? '-' }} • Status: {{ ucfirst($pelatihan->status) }}
                </p>
            </div>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">

            @if(session('success'))
                <div class="bg-emerald-50 border border-emerald-200 text-emerald-700 px-4 py-3 rounded-lg text-sm">
                    {{ session('success') }}
                </div>
            @endif

                {{-- Tambah peserta --}}
                <div class="bg-white shadow-sm sm:rounded-2xl p-4 sm:p-6">
                    <h3 class="text-sm font-semibold text-gray-900 mb-3">
                        Tambah Peserta
                    </h3>

                    <form method="POST" action="{{ route('peserta.store') }}" class="grid grid-cols-1 md:grid-cols-3 gap-3">
                        @csrf

                        {{-- kirim pelatihan_id ke controller --}}
                        <input type="hidden" name="pelatihan_id" value="{{ $pelatihan->id }}">

                        <div class="md:col-span-2">
                            <label class="block text-xs font-medium text-gray-700 mb-1">Pilih Guru</label>
                            <select name="guru_id"
                                    class="block w-full rounded-lg border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                    required>
                                <option value="">– Pilih guru –</option>
                                @foreach($guruList as $g)
                                    <option value="{{ $g->id }}">{{ $g->nama_guru }} ({{ $g->kab_kota ?? 'DKI' }})</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="md:col-span-1">
                            <label class="block text-xs font-medium text-gray-700 mb-1">Status Keikutsertaan</label>
                            <select name="status_keikutsertaan"
                                    class="block w-full rounded-lg border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <option value="terdaftar">Terdaftar</option>
                                <option value="lulus">Lulus</option>
                                <option value="tidak_lulus">Tidak lulus</option>
                            </select>
                        </div>

                        <div class="md:col-span-3 flex justify-end">
                            <button type="submit"
                                    class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-lg font-semibold text-xs text-white uppercase tracking-wide hover:bg-indigo-700">
                                Simpan Peserta
                            </button>
                        </div>
                    </form>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead>
                        <tr class="border-b bg-gray-50">
                            <th class="py-2 px-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Guru</th>
                            <th class="py-2 px-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Kota</th>
                            <th class="py-2 px-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="py-2 px-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">No Sertifikat</th>
                            <th class="py-2 px-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Sertifikat</th>
                            <th class="py-2 px-2 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                        </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                        @forelse($peserta as $row)
                            <tr>
                                <td class="py-2 px-2 text-gray-900 font-semibold">
                                    {{ $row->guru->nama_guru }}
                                </td>
                                <td class="py-2 px-2 text-gray-700">
                                    {{ $row->guru->kab_kota ?? '-' }}
                                </td>
                                <td class="py-2 px-2">
                                    <form method="POST" action="{{ route('pelatihan.peserta.update', $row) }}"
                                          class="inline-flex items-center gap-1">
                                        @csrf
                                        @method('PUT')
                                        <select name="status_keikutsertaan"
                                                class="rounded-md border-gray-300 text-xs focus:border-indigo-500 focus:ring-indigo-500">
                                            @foreach(['terdaftar','hadir','lulus','tidak_lulus'] as $st)
                                                <option value="{{ $st }}" {{ $row->status_keikutsertaan === $st ? 'selected' : '' }}>
                                                    {{ ucfirst($st) }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <button type="submit"
                                                class="text-[11px] text-indigo-600 hover:text-indigo-800">
                                            Simpan
                                        </button>
                                    </form>
                                </td>
                                <td class="py-2 px-2">
                                    <form method="POST" action="{{ route('pelatihan.peserta.update', $row) }}"
                                          class="inline-flex items-center gap-1">
                                        @csrf
                                        @method('PUT')
                                        <input type="hidden" name="status_keikutsertaan" value="{{ $row->status_keikutsertaan }}">
                                        <input type="text" name="nomor_sertifikat"
                                               value="{{ $row->nomor_sertifikat }}"
                                               class="rounded-md border-gray-300 text-xs focus:border-indigo-500 focus:ring-indigo-500 w-32">
                                        <button type="submit"
                                                class="text-[11px] text-indigo-600 hover:text-indigo-800">
                                            Simpan
                                        </button>
                                    </form>
                                </td>
                                <td class="py-2 px-2">
                                    @if($row->sertifikat_path)
                                        <a href="{{ route('pelatihan.peserta.downloadSertifikat', $row) }}"
                                           class="text-xs text-emerald-600 hover:text-emerald-800">
                                            Unduh
                                        </a>
                                    @else
                                        <form method="POST"
                                              action="{{ route('pelatihan.peserta.uploadSertifikat', $row) }}"
                                              enctype="multipart/form-data"
                                              class="flex items-center gap-1 text-xs">
                                            @csrf
                                            <input type="file" name="sertifikat"
                                                   class="text-[11px] border-gray-300 rounded-md focus:border-indigo-500 focus:ring-indigo-500"
                                                   accept="application/pdf" required>
                                            <button type="submit"
                                                    class="text-[11px] text-indigo-600 hover:text-indigo-800">
                                                Upload
                                            </button>
                                        </form>
                                    @endif
                                </td>
                                <td class="py-2 px-2 text-right text-xs text-gray-500">
                                    {{-- bisa ditambah hapus peserta kalau perlu --}}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="py-4 px-2 text-center text-sm text-gray-500">
                                    Belum ada peserta.
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    {{ $peserta->links() }}
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
