@extends('layouts.admin')

@section('title', 'Tambah Peserta Pelatihan - BGTK DKI')
@section('page_title', 'Tambah Peserta Pelatihan')
@section('page_subtitle', 'Daftarkan guru / PTK ke dalam pelatihan yang diselenggarakan BGTK DKI Jakarta')

@section('content')
<div class="card border-0 shadow-sm">
    <div class="card-body">
        <form action="{{ route('peserta.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            {{-- GURU / PTK --}}
            <div class="mb-3">
                <label class="form-label small fw-semibold">Pilih Guru / PTK <span class="text-danger">*</span></label>
                <select name="guru_id" id="guru_id" class="form-select form-select-sm" required>
                    @if(old('guru_id'))
                        @php
                            $guruSelected = \App\Models\Guru::with('sekolah')->find(old('guru_id'));
                        @endphp
                        @if($guruSelected)
                            <option value="{{ $guruSelected->id }}" selected>
                                {{ $guruSelected->nama_guru }}
                                @if($guruSelected->sekolah)
                                    — {{ $guruSelected->sekolah->nama ?? '' }}
                                @endif
                            </option>
                        @endif
                    @endif
                </select>
                @error('guru_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            {{-- PELATIHAN --}}
            <div class="mb-3">
                <label class="form-label small fw-semibold">Pelatihan <span class="text-danger">*</span></label>
                <select name="pelatihan_id" class="form-select form-select-sm @error('pelatihan_id') is-invalid @enderror" required>
                    <option value="">Pilih pelatihan</option>
                    @foreach($pelatihanList as $p)
                        <option value="{{ $p->id }}" {{ old('pelatihan_id') == $p->id ? 'selected' : '' }}>
                            {{ $p->nama_pelatihan }}
                            @if($p->kategori)
                                — {{ $p->kategori }}
                            @endif
                        </option>
                    @endforeach
                </select>
                @error('pelatihan_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            {{-- STATUS --}}
            <div class="mb-3">
                <label class="form-label small fw-semibold">Status Peserta</label>
                <select name="status_keikutsertaan" class="form-select form-select-sm">
                    @php $statusOld = old('status_keikutsertaan', 'terdaftar'); @endphp
                    <option value="terdaftar" {{ $statusOld === 'terdaftar' ? 'selected' : '' }}>Terdaftar</option>
                    <option value="lulus" {{ $statusOld === 'lulus' ? 'selected' : '' }}>Lulus</option>
                    <option value="tidak_lulus" {{ $statusOld === 'tidak_lulus' ? 'selected' : '' }}>Tidak lulus</option>
                </select>
                <div class="form-text small">
                    Status ini digunakan juga untuk menentukan apakah peserta bisa mengunduh sertifikat.
                </div>
            </div>

            {{-- OPTIONAL: SERTIFIKAT --}}
            <div class="mb-3">
                <label class="form-label small fw-semibold">File Sertifikat (opsional)</label>
                <input type="file"
                       name="sertifikat"
                       class="form-control form-control-sm @error('sertifikat') is-invalid @enderror"
                       accept=".pdf,.jpg,.jpeg,.png">
                @error('sertifikat')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <div class="form-text small">
                    Unggah file hanya jika peserta sudah lulus.
                </div>
            </div>

            <hr class="my-3">

            <div class="d-flex justify-content-end gap-2">
                <a href="{{ route('peserta.index') }}" class="btn btn-outline-secondary btn-sm">Batal</a>
                <button type="submit" class="btn btn-primary btn-sm">Simpan</button>
            </div>

        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function () {

    console.log("Select2 URL:", "{{ route('guru.select2') }}");

    $('#guru_id').select2({
        theme: 'bootstrap-5',
        placeholder: 'Cari guru / PTK...',
        allowClear: true,
        minimumInputLength: 1,
        ajax: {
            url: "{{ route('guru.select2') }}",
            type: 'GET',
            dataType: 'json',
            delay: 300,
            data: function (params) {
                return {
                    q: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data.results
                };
            },
            cache: true
        }
    });

});
</script>
@endpush
