@extends('layouts.admin')

@section('title', 'Peserta Pelatihan - BGTK DKI')
@section('page_title', 'Peserta Pelatihan')
@section('page_subtitle', 'Pengelolaan peserta untuk setiap pelatihan yang diselenggarakan BGTK DKI Jakarta')

@section('content')

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show small" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show small" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- CARD FILTER + TOOLBAR --}}
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">
            <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3 mb-3">
                <div>
                    <h6 class="mb-1">Pencarian & Filter Data Peserta</h6>
                    <small class="text-muted">
                        Cari berdasarkan nama guru, NIK, pelatihan, dan status keikutsertaan.
                    </small>
                </div>
                <div class="d-flex gap-2">
                    {{-- tempat export/import peserta kalau nanti perlu --}}
                </div>
            </div>

            <a href="{{ route('peserta.create') }}" class="btn btn-success btn-sm mb-3">
                <i class="bi bi-plus-lg me-1"></i> Tambah Peserta
            </a>

            <form method="GET" action="{{ route('peserta.index') }}" class="row g-2 align-items-end">
                <div class="col-12 col-md-4">
                    <label class="form-label small mb-1">Nama / NIK Guru</label>
                    <input type="text" name="search" value="{{ $search ?? '' }}"
                           class="form-control form-control-sm"
                           placeholder="Cari nama atau NIK guru">
                </div>

                <div class="col-6 col-md-4">
                    <label class="form-label small mb-1">Pelatihan</label>
                    <select name="pelatihan_id" class="form-select form-select-sm">
                        <option value="">Semua pelatihan</option>
                        @foreach($pelatihanList as $p)
                            <option value="{{ $p->id }}" {{ ($pelatihanId ?? '') == $p->id ? 'selected' : '' }}>
                                {{ $p->nama_pelatihan }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-6 col-md-2">
                    <label class="form-label small mb-1">Status</label>
                    <select name="status_keikutsertaan" class="form-select form-select-sm">
                        <option value="">Semua status</option>
                        @foreach($statusOptions as $key => $label)
                            <option value="{{ $key }}" {{ ($status ?? '') == $key ? 'selected' : '' }}>
                                {{ $label }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-12 col-md-2 d-flex gap-2">
                    <button type="submit" class="btn btn-dark btn-sm w-100">
                        <i class="bi bi-search me-1"></i> Terapkan
                    </button>
                    <a href="{{ route('peserta.index') }}"
                       class="btn btn-outline-secondary btn-sm d-none d-md-inline-flex">
                        Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    {{-- TABEL PESERTA --}}
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Daftar Peserta Pelatihan</h6>
                @if(method_exists($peserta, 'total'))
                    <small class="text-muted">
                        Menampilkan {{ $peserta->total() }} data
                        ({{ $peserta->firstItem() ?? 0 }} - {{ $peserta->lastItem() ?? 0 }})
                    </small>
                @endif
            </div>

            <div class="table-responsive mt-2">
                <table class="table table-sm table-hover align-middle">
                    <thead class="table-light small text-uppercase">
                    <tr>
                        <th class="text-center">Nama Peserta</th>
                        <th class="text-center">Pelatihan</th>
                        <th class="text-center">Status Peserta</th>
                        <th class="text-center">Sertifikat</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                    </thead>
                    <tbody class="small">
                    @forelse($peserta as $row)
                        <tr>
                            <td>
                                <div class="fw-semibold">
                                    {{ $row->guru->nama_guru ?? '-' }}
                                </div>
                                <div class="text-muted" style="font-size: 11px;">
                                    {{ $row->guru->sekolah->nama ?? $row->guru->sekolah->nama_sekolah ?? '-' }}
                                </div>
                            </td>
                            <td>
                                <div class="fw-semibold">{{ $row->pelatihan->nama_pelatihan ?? '-' }}</div>
                                <div class="text-muted" style="font-size: 11px;">
                                    {{ $row->pelatihan->kategori ?? '-' }}
                                </div>
                            </td>
                            <td class="text-center">
                                @if($row->status_keikutsertaan === 'lulus')
                                    <span class="badge bg-success-subtle text-success border border-success-subtle">Lulus</span>
                                @elseif($row->status_keikutsertaan === 'tidak_lulus')
                                    <span class="badge bg-danger-subtle text-danger border border-danger-subtle">Tidak lulus</span>
                                @else
                                    <span class="badge bg-secondary-subtle text-secondary border border-secondary-subtle">Terdaftar</span>
                                @endif
                            </td>
                            <td class="text-center">
                                @if($row->sertifikat_path && $row->status_keikutsertaan === 'lulus')
                                    <a href="{{ route('pelatihan.peserta.downloadSertifikat', $row) }}"
                                       class="btn btn-link btn-sm p-0">
                                        <i class="bi bi-file-earmark-arrow-down"></i> Unduh
                                    </a>
                                @else
                                    <span class="text-muted">Belum tersedia</span>
                                @endif
                            </td>
                            <td class="text-center">
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </button>

                                        <ul class="dropdown-menu dropdown-menu-end small shadow">
                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('peserta.edit', $row) }}">
                                                    <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                                </a>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>

                                            <li>
                                                <form action="{{ route('peserta.destroy', $row->id) }}"
                                                    method="POST"
                                                    onsubmit="return confirm('Yakin ingin menghapus data guru ini?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item text-danger">
                                                        <i class="bi bi-trash me-2"></i> Hapus
                                                    </button>
                                                </form>
                                            </li>

                                        </ul>
                                    </div>
                                </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center text-muted py-4">
                                Belum ada data peserta pelatihan.
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            @if(method_exists($peserta, 'links'))
                <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mt-3 small text-muted gap-2">
                    <div>
                        Menampilkan {{ $peserta->firstItem() ?? 0 }} - {{ $peserta->lastItem() ?? 0 }}
                        dari {{ $peserta->total() }} data
                    </div>
                    <div>
                        {{ $peserta->onEachSide(1)->links() }}
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection
