@extends('layouts.admin')

@section('title', 'Data Registrasi Peserta - BGTK DKI')
@section('page_title', 'Data Registrasi Peserta')
@section('page_subtitle', 'Daftar peserta yang telah melakukan registrasi pelatihan')

@section('content')

    {{-- ================= ALERT ================= --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show small">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show small">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- ================= FILTER ================= --}}
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">

            <div class="mb-3">
                <h6 class="mb-1">Pencarian Data Registrasi</h6>
                <small class="text-muted">
                    Cari berdasarkan nama, NIK, email, atau pelatihan.
                </small>
            </div>

            <form method="GET" action="{{ route('admin.registrasi.index') }}" class="row g-2">
                <div class="col-12 col-md-4">
                    <label class="form-label form-label-sm mb-1 small">Nama / NIK / Email</label>
                    <input type="text" name="search" value="{{ request('search') }}" class="form-control form-control-sm"
                        placeholder="Cari peserta">
                </div>

                <div class="col-12 col-md-4">
                    <label class="form-label form-label-sm mb-1 small">Pelatihan</label>
                    <select name="pelatihan" class="form-select form-select-sm">
                        <option value="">Semua pelatihan</option>
                        @foreach($pelatihanList as $p)
                            <option value="{{ $p }}" {{ request('pelatihan') == $p ? 'selected' : '' }}>
                                {{ $p }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- ACTION BUTTON --}}
                <div class="col-12 col-md-4 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-dark btn-sm">
                        <i class="bi bi-search me-1"></i> Terapkan
                    </button>

                    <a href="{{ route('admin.registrasi.index') }}" class="btn btn-outline-secondary btn-sm">
                        Reset
                    </a>

                    <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal"
                        data-bs-target="#modalImportRegistrasi">
                        <i class="bi bi-upload me-1"></i> Import
                    </button>
                </div>
            </form>

        </div>
    </div>

    {{-- ================= TABLE ================= --}}
    <div class="card border-0 shadow-sm">
        <div class="card-body">

            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Daftar Registrasi Peserta</h6>
                @if(method_exists($registrasi, 'total'))
                    <small class="text-muted">
                        Menampilkan {{ $registrasi->firstItem() ?? 0 }} -
                        {{ $registrasi->lastItem() ?? 0 }}
                        dari {{ $registrasi->total() }} data
                    </small>
                @endif
            </div>

            <div class="table-responsive mt-2">
                <table class="table table-sm table-hover align-middle">
                    <thead class="table-light small text-uppercase">
                        <tr>
                            <th>Nama Peserta</th>
                            <th class="text-center">Pelatihan</th>
                            <th class="text-center">Pangkat Golongan</th>
                            <th class="text-center">Instansi</th>
                            <th class="text-center">No HP</th>
                            <th>Email</th>
                            <th class="text-center">Tgl Daftar</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>

                    <tbody class="small">
                        @forelse($registrasi as $r)
                            <tr>
                                <td>
                                    <div class="fw-semibold">{{ $r->nama }}</div>
                                    <div class="text-muted" style="font-size:11px;">
                                        NIK : {{ $r->nik ?? '-' }} · <br> Jabatan : {{ $r->jabatan ?? '-' }}
                                    </div>
                                </td>
                                <td class="text-center">{{ $r->nama_kegiatan }}</td>
                                <td class="text-center">{{ $r->pangkat_golongan }}</td>
                                <td class="text-center">{{ $r->unit_kerja }}</td>
                                <td class="text-center">{{ $r->no_hp }}</td>
                                <td>{{ $r->email_pribadi }}</td>
                                <td class="text-center">
                                    {{ $r->created_at?->format('d-m-Y') }}
                                </td>
                                <td class="text-center">
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </button>

                                        <ul class="dropdown-menu dropdown-menu-end small shadow">

                                            {{-- DETAIL --}}
                                            <li>
                                                <a class="dropdown-item"
                                                href="{{ route('admin.registrasi.show', $r) }}">
                                                    <i class="bi bi-eye me-2 text-info"></i> Detail
                                                </a>
                                            </li>

                                            {{-- EDIT --}}
                                            <li>
                                                <a class="dropdown-item"
                                                href="{{ route('admin.registrasi.edit', $r) }}">
                                                    <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                                </a>
                                            </li>

                                            <li><hr class="dropdown-divider"></li>

                                            {{-- HAPUS --}}
                                            <li>
                                                <form action="{{ route('admin.registrasi.destroy', $r) }}"
                                                    method="POST"
                                                    onsubmit="return confirm('Yakin ingin menghapus data registrasi ini?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item text-danger">
                                                        <i class="bi bi-trash me-2"></i> Hapus
                                                    </button>
                                                </form>
                                            </li>

                                        </ul>
                                    </div>
                                </td>

                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">
                                    Belum ada data registrasi peserta.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- PAGINATION --}}
            @if(method_exists($registrasi, 'links'))
                <div class="d-flex justify-content-between align-items-center mt-3 small">
                    <div>
                        Menampilkan {{ $registrasi->firstItem() ?? 0 }} -
                        {{ $registrasi->lastItem() ?? 0 }}
                        dari {{ $registrasi->total() }} data
                    </div>
                    <div>
                        {{ $registrasi->appends(request()->query())
                ->onEachSide(1)
                ->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            @endif

        </div>
    </div>

    {{-- ================= MODAL IMPORT ================= --}}
    <div class="modal fade" id="modalImportRegistrasi" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <form action="{{ route('admin.registrasi.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="modal-header">
                        <h6 class="modal-title">Import Data Registrasi</h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body small">
                        <label class="form-label">File Excel (.xlsx)</label>
                        <input type="file" name="file" class="form-control form-control-sm" accept=".xls,.xlsx" required>

                        <small class="text-muted mt-2 d-block">
                            Pastikan header sesuai template.
                        </small>
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-success btn-sm">
                            <i class="bi bi-upload me-1"></i> Import
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection