@extends('layouts.admin')

@section('title', 'Data Sekolah - BGTK DKI')
@section('page_title', 'Data Sekolah DKI Jakarta')
@section('page_subtitle', 'Master data sekolah hasil sinkronisasi Dapodik untuk mendukung pengelolaan PTK dan pelatihan')

@section('content')

    {{-- Alert --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show small" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show small" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif


    {{-- ===========================
    CARD FILTER + TOOLBAR
    ============================ --}}
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">

            <div
                class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3 mb-3">
                <div>
                    <h6 class="mb-1">Pencarian &amp; Filter Data Sekolah</h6>
                    <small class="text-muted">
                        Cari berdasar nama, NPSN, kota, jenjang, dan status sekolah.
                    </small>
                </div>

                {{-- Toolbar Import & Export --}}
                <div class="d-flex flex-wrap gap-2">
                    <a href="{{ route('sekolah.export', request()->query()) }}" class="btn btn-outline-secondary btn-sm">
                        <i class="bi bi-download me-1"></i> Export
                    </a>


                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalImportSekolah">
                        <i class="bi bi-upload me-1"></i> Import
                    </button>
                </div>
            </div>

            <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-2">
                <a href="{{ route('sekolah.create') }}" class="btn btn-success btn-sm">
                    <i class="bi bi-plus-lg me-1"></i> Tambah Sekolah
                </a>
            </div>

            {{-- Form Filter --}}
            <form method="GET" action="{{ route('sekolah.index') }}" class="row g-2">
                <div class="col-12 col-md-4">
                    <label class="form-label form-label-sm mb-1 small">Nama / NPSN / ID Dapodik</label>
                    <input type="text" name="search" value="{{ $search ?? '' }}" class="form-control form-control-sm"
                        placeholder="Cari sekolah, NPSN, atau ID Dapodik">
                </div>

                {{-- Kota --}}
                <div class="col-6 col-md-3">
                    <label class="form-label form-label-sm mb-1 small">Kota</label>
                    <select name="kabupaten" class="form-select form-select-sm">
                        <option value="">Semua kota</option>
                        @foreach($kabupatenOptions as $kab)
                            <option value="{{ $kab }}" {{ ($kabupaten ?? '') == $kab ? 'selected' : '' }}>
                                {{ $kab }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- Jenjang --}}
                <div class="col-6 col-md-2">
                    <label class="form-label form-label-sm mb-1 small">Jenjang</label>
                    <select name="jenjang" class="form-select form-select-sm">
                        <option value="">Semua jenjang</option>
                        @foreach($jenjangList as $row)
                            <option value="{{ $row->jenjang }}" {{ ($jenjang ?? '') == $row->jenjang ? 'selected' : '' }}>
                                {{ $row->jenjang }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- Status Sekolah --}}
                <div class="col-6 col-md-3">
                    <label class="form-label form-label-sm mb-1 small">Status Sekolah</label>
                    <select name="status_sekolah" class="form-select form-select-sm">
                        <option value="">Semua status</option>
                        @foreach($statusOptions as $st)
                            <option value="{{ $st }}" {{ ($status ?? '') == $st ? 'selected' : '' }}>
                                {{ $st }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-12 col-md-2 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-dark btn-sm w-100">
                        <i class="bi bi-search me-1"></i> Terapkan
                    </button>

                    <a href="{{ route('sekolah.index') }}" class="btn btn-outline-secondary btn-sm d-none d-md-inline-flex">
                        Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    {{-- ===========================
    TABLE DATA SEKOLAH
    ============================ --}}
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-2 gap-1">
                <h6 class="mb-0">Daftar Sekolah</h6>
                @if(method_exists($sekolah, 'total'))
                    <small class="text-muted">
                        Menampilkan {{ $sekolah->firstItem() ?? 0 }} - {{ $sekolah->lastItem() ?? 0 }}
                        dari {{ $sekolah->total() }} data
                    </small>
                @endif
            </div>

            <div class="table-responsive mt-2">
                <table class="table table-sm table-hover align-middle">
                    <thead class="table-light small text-uppercase">
                        <tr>
                            <th class="text-center">Nama Sekolah</th>
                            <th class="text-center" style="width: 90px;">NPSN</th>
                            <th class="text-center" style="width: 160px;">Kota</th>
                            <th style="width: 170px;">Kecamatan</th>
                            <th class="text-center" style="width: 90px;">Jenjang</th>
                            <th class="text-center" style="width: 120px;">Status</th>
                            <th>Alamat</th>
                            <th class="text-center" style="width: 90px;">Aksi</th>
                        </tr>
                    </thead>

                    <tbody class="small">
                        @forelse($sekolah as $s)
                            <tr>
                                <td>
                                    <div class="fw-semibold">{{ $s->nama }}</div>
                                    <div class="text-muted" style="font-size: 11px;">
                                        ID Dapodik: {{ $s->sekolah_id ?? '-' }}
                                    </div>
                                </td>
                                <td>{{ $s->npsn ?? '-' }}</td>
                                <td>{{ $s->kabupaten ?? '-' }}</td>
                                <td>{{ $s->kecamatan ?? '-' }}</td>
                                <td class="text-center">{{ $s->jenjang ?? '-' }}</td>
                                <td class="text-center">{{ $s->status_sekolah ?? '-' }}</td>
                                <td>{{ $s->alamat_jalan ?? '-' }}</td>
                                <td class="text-center">
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </button>

                                        <ul class="dropdown-menu dropdown-menu-end small shadow">
                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('sekolah.show', $s) }}">
                                                    <i class="bi bi-eye me-2 text-info"></i> Detail
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="{{ route('sekolah.edit', $s) }}">
                                                    <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                                </a>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>

                                            <li>
                                                <form action="{{ route('sekolah.destroy', $s) }}"
                                                    method="POST"
                                                    onsubmit="return confirm('Yakin ingin menghapus data sekolah ini?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item text-danger">
                                                        <i class="bi bi-trash me-2"></i> Hapus
                                                    </button>
                                                </form>
                                            </li>

                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">
                                    Belum ada data sekolah. Silakan import dari file Dapodik.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if(method_exists($sekolah, 'links'))
                <div
                    class="d-flex flex-column flex-md-row justify-content-between align-items-center mt-3 small text-muted gap-2">
                    <div>
                        Menampilkan {{ $sekolah->firstItem() ?? 0 }} - {{ $sekolah->lastItem() ?? 0 }}
                        dari {{ $sekolah->total() }} data
                    </div>
                    <div class="d-flex justify-content-center">
                        {{ $sekolah->appends(request()->query())
                ->onEachSide(1)
                ->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            @endif

        </div>
    </div>

    {{-- ===========================
    MODAL IMPORT SEKOLAH
    ============================ --}}
    <div class="modal fade" id="modalImportSekolah" tabindex="-1" aria-labelledby="modalImportSekolahLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header py-2">
                    <h6 class="modal-title" id="modalImportSekolahLabel">Import Data Sekolah</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <form action="{{ route('sekolah.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-2 small text-muted">
                            Upload file Excel sesuai format <strong>Data Sekolah Dapodik</strong>.
                        </div>

                        <div class="mb-3">
                            <input type="file" name="file" class="form-control form-control-sm" accept=".xlsx,.xls"
                                required>
                        </div>
                    </div>

                    <div class="modal-footer py-2">
                        <button type="button" class="btn btn-light btn-sm" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="bi bi-upload me-1"></i> Import
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection