@extends('layouts.admin')

@section('content')
<div class="container py-3">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <div>
      <h4 class="mb-0">{{ $sekolah->nama }}</h4>
      <div class="text-muted small">NPSN: {{ $sekolah->npsn }} • Jenjang: {{ $sekolah->jenjang }}</div>
    </div>
    <div class="d-flex gap-2">
      <a href="{{ route('sekolah.edit', $sekolah->id) }}" class="btn btn-warning btn-sm">Edit</a>
      <a href="{{ route('sekolah.index') }}" class="btn btn-secondary btn-sm">Kembali</a>
    </div>
  </div>

  <div class="card mb-3">
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-6">
          <div class="fw-bold">Alamat</div>
          <div class="text-muted">{{ $sekolah->alamat }}</div>
        </div>
        <div class="col-md-3">
          <div class="fw-bold">Kab/Kota</div>
          <div class="text-muted">{{ $sekolah->kabupaten }}</div>
        </div>
        <div class="col-md-3">
          <div class="fw-bold">Provinsi</div>
          <div class="text-muted">{{ $sekolah->provinsi }}</div>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="card-header fw-bold d-flex justify-content-between">
      <span>Daftar PTK di Sekolah Ini</span>
      <span class="badge bg-primary">{{ $sekolah->guru->count() }}</span>
    </div>
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-striped mb-0">
          <thead>
            <tr>
              <th>Nama</th>
              <th>NIP</th>
              <th>NIK</th>
              <th>Jabatan</th>
              <th class="text-end">Aksi</th>
            </tr>
          </thead>
          <tbody>
            @forelse($sekolah->guru as $g)
              <tr>
                <td>{{ $g->nama_guru }}</td>
                <td>{{ $g->nip }}</td>
                <td>{{ $g->nik }}</td>
                <td>{{ $g->jabatan }}</td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-primary" href="{{ route('guru.show', $g->id) }}">Detail</a>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="5" class="text-center text-muted py-3">Belum ada data PTK terkait sekolah ini.</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
    </div>
  </div>

</div>
@endsection
