<!doctype html>
<html lang="id">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Form Registrasi</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    body {
      background: #f4f6fb;
    }

    .paper {
      background: #fff;
      border: 1px solid #e5e7eb;
      border-radius: 14px;
    }

    .kop {
      border: 1px solid #111;
      border-radius: 12px;
    }

    .kop .logo {
      width: 70px;
      height: auto;
    }

    .kop .title {
      font-weight: 800;
      letter-spacing: .3px;
    }

    .req {
      color: #dc3545;
      font-weight: 800;
    }

    .form-label {
      font-weight: 700;
      margin-bottom: .2rem;
    }

    .form-text {
      margin-top: .2rem;
    }

    .form-control,
    .form-select {
      border-radius: 12px;
      padding: .65rem .8rem;
    }

    .btn {
      border-radius: 12px;
      font-weight: 700;
    }

    .section-title {
      font-weight: 800;
    }

    .divider {
      border-top: 1px solid #eef2f7;
      margin: 18px 0;
    }

    .is-invalid {
      border-color: #dc3545 !important;
    }

    /* SLIDE */
    .form-slide {
      display: none;
    }

    .form-slide.active {
      display: block;
    }

    .step-indicator {
      display: flex;
      gap: .5rem;
      margin-bottom: 1rem;
    }

    .step {
      flex: 1;
      text-align: center;
      padding: .6rem;
      font-weight: 700;
      border-radius: 10px;
      background: #e5e7eb;
      font-size: .9rem;
    }

    .step.active {
      background: #198754;
      color: #fff;
    }
  </style>
</head>

<body>

  <div class="container py-4">
    <div class="paper p-3 p-md-4 shadow-sm">

      <div class="kop p-3 mb-3">
        <div class="d-flex align-items-center gap-3">
          <img src="{{ asset('images/Logo.png') }}" class="logo" alt="Logo">
          <div class="flex-grow-1 text-center">
            <div class="title">BGTK PROVINSI DKI JAKARTA</div>
            <div class="fw-semibold">FORM REGISTRASI PESERTA</div>
          </div>
        </div>
      </div>

      @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
      @endif

      @if ($errors->any())
        <div class="alert alert-danger">
          <ul class="mb-0">
            @foreach ($errors->all() as $e)
              <li>{{ $e }}</li>
            @endforeach
          </ul>
        </div>
      @endif

      <div id="alertRequired" class="alert alert-danger d-none">
        ⚠️ Masih ada data wajib yang belum diisi. Silakan lengkapi terlebih dahulu.
      </div>

      <form method="POST" action="{{ route('portal.registrasi.store') }}" enctype="multipart/form-data">
        @csrf

        {{-- STEP --}}
        <div class="step-indicator">
          <div class="step active">1. Data Diri</div>
          <div class="step">2. Unit Kerja</div>
          <div class="step">3. Alamat Rumah</div>
        </div>

        {{-- PILIH PELATIHAN --}}
        <div class="mb-3">
          <label class="form-label">Nama Kegiatan <span class="req">*</span></label>
          <select id="pelatihanSelect" name="pelatihan_id"
            class="form-select @error('pelatihan_id') is-invalid @enderror" required>
            <option value="">- Pilih Pelatihan -</option>
            @foreach($pelatihanList as $p)
              <option value="{{ $p->id }}" data-nama="{{ $p->nama_pelatihan }}" @selected(old('pelatihan_id') == $p->id)>
                {{ $p->nama_pelatihan }}
              </option>
            @endforeach
          </select>
          <input type="hidden" id="namaKegiatan" name="nama_kegiatan">
        </div>

        {{-- SLIDE 1 --}}
        <div class="form-slide active">

          <h6 class="section-title mb-2">Data Diri</h6>

          <div class="row g-3">
            <div class="col-md-4">
              <label class="form-label">Foto Diri</label>
              <div class="form-text">Opsional (JPG / PNG) *Maks 2Mb</div>
              <input type="file" name="foto" class="form-control" accept="image/*">
            </div>

            <div class="col-md-8"></div>

            <div class="col-md-6">
              <label class="form-label">Nama <span class="req">*</span></label>
              <input name="nama" class="form-control" value="{{ old('nama') }}" required>
            </div>

            <div class="col-md-6">
              <label class="form-label">NIK <span class="req">*</span></label>
              <input
                name="nik"
                class="form-control digits-only @error('nik') is-invalid @enderror"
                placeholder="Hanya angka (16 digit). Contoh: 3174xxxxx"
                inputmode="numeric"
                autocomplete="off"
                value="{{ old('nik') }}"
                maxlength="16"
                required
              >
              @error('nik')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">NIP</label>
              <input
                name="nip"
                class="form-control digits-only @error('nip') is-invalid @enderror"
                placeholder="Input Jika Ada"
                inputmode="numeric"
                autocomplete="off"
                value="{{ old('nip') }}"
              >
              @error('nip')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">
                Jabatan<span class="req">*</span>
              </label>

              <select
                name="jabatan"
                class="form-select @error('jabatan') is-invalid @enderror"
                required
              >
                <option value="">-- Pilih Jabatan --</option>

                @foreach ([
                  'Guru',
                  'Kepala Sekolah',
                  'Pengawas',
                  'Laboran',
                  'Pustakawan',
                  'Tenaga Administrasi',
                  'Operator Sekolah'
                ] as $jabatan)
                  <option
                    value="{{ $jabatan }}"
                    @selected(old('jabatan') == $jabatan)
                  >
                    {{ $jabatan }}
                  </option>
                @endforeach
              </select>

              @error('jabatan')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Pangkat / Golongan</label>

              <select
                name="pangkat_golongan"
                class="form-select @error('pangkat_golongan') is-invalid @enderror"
              >
                <option value="">-- Pilih Pangkat / Golongan --</option>

                @foreach (['IIA','IIB','IIC','IID','IIIA','IIIB','IIIC','IIID','IVA','IVB','IVC','IVD','IVE'] as $pg)
                  <option value="{{ $pg }}" @selected(old('pangkat_golongan') == $pg)>
                    {{ $pg }}
                  </option>
                @endforeach
              </select>

              @error('pangkat_golongan')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>


            <div class="col-md-6">
              <label class="form-label">Tempat Lahir<span class="req">*</span></label>
              <input
                name="tempat_lahir"
                class="form-control @error('tempat_lahir') is-invalid @enderror"
                placeholder="Contoh: Jakarta, Bandung, Surabaya, Yogyakarta."
                value="{{ old('tempat_lahir') }}"
                required
              >
              @error('tempat_lahir')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Tanggal Lahir <span class="req">*</span></label>
              <input type="date" name="tanggal_lahir" class="form-control" value="{{ old('tanggal_lahir') }}">
            </div>

            <div class="col-md-6">
              <label class="form-label">No HP (WA)<span class="req">*</span></label>
              <input
                name="no_hp"
                class="form-control digits-only @error('no_hp') is-invalid @enderror"
                placeholder="Awali dengan 62. Contoh: 628xxxx"
                inputmode="numeric" autocomplete="off"
                value="{{ old('no_hp') }}"
                required
              >
              @error('no_hp')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Email Pribadi<span class="req">*</span></label>
              <input
                type="email"
                name="email_pribadi"
                class="form-control @error('email_pribadi') is-invalid @enderror"
                placeholder="Contoh: nama@gmail.com"
                value="{{ old('email_pribadi') }}"
                required
              >
              @error('email_pribadi')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Pendidikan Terakhir<span class="req">*</span></label>
              <input
                name="pendidikan_terakhir"
                class="form-control @error('pendidikan_terakhir') is-invalid @enderror"
                placeholder="Contoh: S1, S2, S3, D3, D4, D3"
                value="{{ old('pendidikan_terakhir') }}"
                required
              >
              @error('pendidikan_terakhir')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Prodi<span class="req">*</span></label>
              <input
                name="prodi"
                class="form-control @error('prodi') is-invalid @enderror"
                placeholder="Contoh: Sistem Informasi, Teknik Informatika, Desain Komunikasi Visual"
                value="{{ old('prodi') }}"
                required
              >
              @error('prodi')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Agama <span class="req">*</span></label>
              <select name="agama" class="form-select" required>
                <option value="">- Pilih -</option>
                @foreach($agamaOptions as $ag)
                  <option value="{{ $ag }}" @selected(old('agama') == $ag)>{{ $ag }}</option>
                @endforeach
              </select>
            </div>

            <div class="col-md-6">
              <label class="form-label">Jenis Kelamin <span class="req">*</span></label>
              <select name="jenis_kelamin" class="form-select" required>
                <option value="">- Pilih -</option>
                <option value="Laki-laki">Laki-laki</option>
                <option value="Perempuan">Perempuan</option>
              </select>
            </div>
          </div>

          <div class="d-flex justify-content-end mt-4">
            <button type="button" class="btn btn-success next-btn">Selanjutnya →</button>
          </div>
        </div>

        {{-- SLIDE 2 --}}
        <div class="form-slide">
          <h6 class="section-title mb-2">Unit Kerja</h6>

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Unit Kerja <span class="req">*</span></label>
              <input
                name="unit_kerja"
                class="form-control @error('unit_kerja') is-invalid @enderror"
                placeholder="Contoh: SMPN 105 Jakarta"
                value="{{ old('unit_kerja') }}"
                required
              >
              @error('unit_kerja')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">NPSN<span class="req">*</span></label>
              <input
                name="npsn"
                class="form-control @error('npsn') is-invalid @enderror"
                placeholder="Wajib input NPSN"
                value="{{ old('npsn') }}"
                required
              >
              @error('npsn')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Telp Instansi <span class="req">*</span></label>
              <input
                name="telp_instansi"
                class="form-control digits-only @error('telp_instansi') is-invalid @enderror"
                placeholder="Hanya Angka"
                inputmode="numeric" autocomplete="off"
                value="{{ old('telp_instansi') }}"
                required
              >
              @error('telp_instansi')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Kab/Kota<span class="req">*</span></label>
              <input
                name="kab_kota_unit"
                class="form-control @error('kab_kota_unit') is-invalid @enderror"
                placeholder="Cotoh: Jakarta Selatan"
                value="{{ old('kab_kota_unit') }}"
                required
              >
              @error('kab_kota_unit')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Provinsi<span class="req">*</span></label>
              <input
                name="provinsi_unit"
                class="form-control @error('provinsi_unit') is-invalid @enderror"
                placeholder="Contoh: DKI Jakarta"
                value="{{ old('provinsi_unit') }}"
                required
              >
              @error('provinsi_unit')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Kode Pos<span class="req">*</span></label>
              <input
                name="kode_pos_unit"
                class="form-control digits-only @error('kode_pos_unit') is-invalid @enderror"
                placeholder="Hanya Angka"
                inputmode="numeric" autocomplete="off"
                value="{{ old('kode_pos_unit') }}"
                required
              >
              @error('kode_pos_unit')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-12">
              <label class="form-label">Alamat Unit Kerja <span class="req">*</span></label>
              <textarea name="alamat_unit_kerja" class="form-control" required>{{ old('alamat_unit_kerja') }}</textarea>
            </div>
          </div>

          <div class="d-flex justify-content-between mt-4">
            <button type="button" class="btn btn-secondary prev-btn">← Kembali</button>
            <button type="button" class="btn btn-success next-btn">Selanjutnya →</button>
          </div>
        </div>

        {{-- SLIDE 3 --}}
        <div class="form-slide">
          <h6 class="section-title mb-2">Alamat Rumah</h6>

          <div class="row g-3">
            <div class="col-12">
              <label class="form-label">Alamat Rumah <span class="req">*</span></label>
              <textarea name="alamat_rumah" class="form-control" required>{{ old('alamat_rumah') }}</textarea>
            </div>

            <div class="col-md-6">
              <label class="form-label">Kab/Kota<span class="req">*</span></label>
              <input
                name="kab_kota_rumah"
                class="form-control @error('kab_kota_rumah') is-invalid @enderror"
                placeholder="Contoh: Jakarta Selatan, Depok"
                value="{{ old('kab_kota_rumah') }}"
                required
              >
              @error('kab_kota_rumah')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Provinsi<span class="req">*</span></label>
              <input
                name="provinsi_rumah"
                class="form-control @error('provinsi_rumah') is-invalid @enderror"
                placeholder="Contoh: DKI Jakarta, Jawa Barat"
                value="{{ old('provinsi_rumah') }}"
                required
              >
              @error('provinsi_rumah')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="col-md-6">
              <label class="form-label">Kode Pos<span class="req">*</span></label>
              <input
                name="kode_pos_rumah"
                class="form-control digits-only @error('kode_pos_rumah') is-invalid @enderror"
                placeholder="Hanya Angka"
                inputmode="numeric" autocomplete="off"
                value="{{ old('kode_pos_rumah') }}"
                required
              >
              @error('kode_pos_rumah')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>
          </div>

          <div class="divider"></div>

          <h6 class="section-title mb-2">NPWP & Bank</h6>
          <div class="row g-3">
            <div class="col-md-4">
              <label class="form-label">NPWP <span class="req">*</span></label>
              <input name="npwp" class="form-control digits-only" value="{{ old('npwp') }}" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Bank <span class="req">*</span></label>
              <input name="bank" class="form-control" value="{{ old('bank') }}" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">No Rekening <span class="req">*</span></label>
              <input name="no_rekening" class="form-control digits-only" value="{{ old('no_rekening') }}" required>
            </div>
          </div>

          <div class="d-flex justify-content-between mt-4">
            <button type="button" class="btn btn-secondary prev-btn">← Kembali</button>
            <button class="btn btn-success px-4">Simpan</button>
          </div>
        </div>

      </form>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    (function () {
      const slides = document.querySelectorAll('.form-slide');
      const steps  = document.querySelectorAll('.step');
      const alertBox = document.getElementById('alertRequired');
      let current = 0;

      function show(i) {
        slides.forEach((s, idx) => s.classList.toggle('active', idx === i));
        steps.forEach((s, idx) => s.classList.toggle('active', idx === i));
        current = i;
        window.scrollTo({ top: 0, behavior: 'smooth' });
      }

      function validateSlide(index) {
        let valid = true;
        const requiredFields = slides[index].querySelectorAll('[required]');

        requiredFields.forEach(el => {
          if (!el.value.trim()) {
            el.classList.add('is-invalid');
            valid = false;
          } else {
            el.classList.remove('is-invalid');
          }
        });

        alertBox.classList.toggle('d-none', valid);
        return valid;
      }

      function validateAllSlides() {
        for (let i = 0; i < slides.length; i++) {
          if (!validateSlide(i)) {
            show(i);
            return false;
          }
        }
        return true;
      }

      document.querySelectorAll('.next-btn').forEach(btn => {
        btn.addEventListener('click', () => {
          if (validateSlide(current)) {
            show(current + 1);
          }
        });
      });

      document.querySelectorAll('.prev-btn').forEach(btn => {
        btn.addEventListener('click', () => show(current - 1));
      });

      document.querySelector('form').addEventListener('submit', function (e) {
        if (!validateAllSlides()) {
          e.preventDefault();
        }
      });

      document.querySelectorAll('.digits-only').forEach(el => {
        el.addEventListener('input', () => el.value = el.value.replace(/\D/g, ''));
      });
    })();
  </script>

</body>

</html>