<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Login - BGTK DKI</title>

    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

    <style>
        body {
            min-height: 100vh;
            background: #f3f4f6;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1.5rem;
        }
        .auth-wrapper {
            max-width: 420px;
            width: 100%;
        }
        .auth-card {
            border-radius: 1.5rem;
            border: 1px solid #e5e7eb;
            background: #ffffff;
            box-shadow: 0 20px 45px rgba(15, 23, 42, 0.18);
            padding: 2rem 2.25rem;
        }
        .auth-logo {
            width: 190px;
            height: auto;
            object-fit: contain;
            margin-bottom: 0.25rem !important;
        }

        .auth-card h4 {
            margin-top: -10px !important;
            letter-spacing: 0.05em;
        }
        
        .auth-card p {
            margin-top: -2px; 
        }
        .auth-title {
            letter-spacing: 0.12em;
        }
        .input-icon {
            width: 38px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6b7280;
        }
        .form-control:focus {
            box-shadow: 0 0 0 0.15rem rgba(37, 99, 235, 0.25);
        }
        .btn-primary {
            background: #2563eb;
            border-color: #2563eb;
        }
        .btn-primary:hover {
            background: #1d4ed8;
            border-color: #1d4ed8;
        }
        .toggle-password-btn {
            border: none;
            background: transparent;
            color: #6b7280;
        }
    </style>
</head>
<body>
<div class="auth-wrapper">

<div class="auth-card">
        
        <div class="text-center mb-4">
            <img src="<?php echo e(asset('images/logo_terbaru1.png')); ?>"
                 alt="Logo BGTK DKI"
                 class="auth-logo">

            
            <h4 class="mb-0 fw-bold">LOGIN</h4>
            <p class="mb-0 small opacity-75">
                Sistem Informasi BGTK DKI Jakarta
            </p>
        </div>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success py-2 small">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <div class="alert alert-danger py-2 small">
                <?php echo e($errors->first()); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('login.post')); ?>">
            <?php echo csrf_field(); ?>

            
            <div class="mb-3">
                <label class="form-label small mb-1">Email</label>
                <div class="input-group input-group-sm">
                    <span class="input-group-text bg-white input-icon">
                        <i class="bi bi-person"></i>
                    </span>
                    <input
                        type="email"
                        name="email"
                        class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        value="<?php echo e(old('email')); ?>"
                        required
                        autocomplete="email"
                        autofocus
                    >
                </div>
            </div>

            
            <div class="mb-2">
                <label class="form-label small mb-1">Password</label>
                <div class="input-group input-group-sm">
                    <span class="input-group-text bg-white input-icon">
                        <i class="bi bi-lock"></i>
                    </span>
                    <input
                        type="password"
                        name="password"
                        id="password"
                        class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        required
                        autocomplete="current-password"
                    >
                    <button type="button"
                            class="input-group-text toggle-password-btn"
                            data-target="#password">
                        <i class="bi bi-eye-slash"></i>
                    </button>
                </div>
            </div>

            <div class="d-flex justify-content-end mb-3">
                <a href="#" class="small text-decoration-none text-muted">
                    Lupa kata sandi?
                </a>
            </div>

            
            <div class="d-grid mb-3">
                <button type="submit" class="btn btn-primary btn-sm py-2">
                    Masuk
                </button>
            </div>

            
            <div class="text-center small">
                Belum punya akun?
                <a href="<?php echo e(route('register')); ?>" class="text-decoration-none">
                    Daftar Sekarang!
                </a>
            </div>
        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.querySelectorAll('.toggle-password-btn').forEach(function (btn) {
        btn.addEventListener('click', function () {
            const target = document.querySelector(this.dataset.target);
            const icon = this.querySelector('i');
            if (!target) return;

            if (target.type === 'password') {
                target.type = 'text';
                icon.classList.remove('bi-eye-slash');
                icon.classList.add('bi-eye');
            } else {
                target.type = 'password';
                icon.classList.remove('bi-eye');
                icon.classList.add('bi-eye-slash');
            }
        });
    });
</script>
</body>
</html>
<?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/auth/login.blade.php ENDPATH**/ ?>