<?php $__env->startSection('title', 'Dashboard Admin - BGTK DKI'); ?>
<?php $__env->startSection('page_title', 'Dashboard'); ?>
<?php $__env->startSection('page_subtitle', 'Ringkasan data utama sistem BGTK DKI Jakarta'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-6 col-lg-3 col-md-6">
        <div class="card">
            <div class="card-body px-4 py-4-5">
                <div class="row">
                    <div class="col-md-4 col-lg-12 col-xl-12 col-xxl-5 d-flex justify-content-start">
                        <div class="stats-icon purple mb-2">
                            <i class="iconly-boldProfile"></i>
                        </div>
                    </div>
                    <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                        <h6 class="text-muted font-semibold">Total PTK / Guru</h6>
                        <h6 class="font-extrabold mb-0"><?php echo e(number_format($totalPtk ?? 0)); ?></h6>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-6 col-lg-3 col-md-6">
        <div class="card">
            <div class="card-body px-4 py-4-5">
                <div class="row">
                    <div class="col-md-4 col-lg-12 col-xl-12 col-xxl-5 d-flex justify-content-start">
                        <div class="stats-icon blue mb-2">
                            <i class="iconly-boldHome"></i>
                        </div>
                    </div>
                    <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                        <h6 class="text-muted font-semibold">Total Sekolah</h6>
                        <h6 class="font-extrabold mb-0"><?php echo e(number_format($totalSekolah ?? 0)); ?></h6>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-6 col-lg-3 col-md-6">
        <div class="card">
            <div class="card-body px-4 py-4-5">
                <div class="row">
                    <div class="col-md-4 col-lg-12 col-xl-12 col-xxl-5 d-flex justify-content-start">
                        <div class="stats-icon green mb-2">
                            <i class="iconly-boldWork"></i>
                        </div>
                    </div>
                    <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                        <h6 class="text-muted font-semibold">Total Pelatihan</h6>
                        <h6 class="font-extrabold mb-0"><?php echo e(number_format($totalPelatihan ?? 0)); ?></h6>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-6 col-lg-3 col-md-6">
        <div class="card">
            <div class="card-body px-4 py-4-5">
                <div class="row">
                    <div class="col-md-4 col-lg-12 col-xl-12 col-xxl-5 d-flex justify-content-start">
                        <div class="stats-icon red mb-2">
                            <i class="iconly-boldAdd-User"></i>
                        </div>
                    </div>
                    <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                        <h6 class="text-muted font-semibold">Total Peserta</h6>
                        <h6 class="font-extrabold mb-0"><?php echo e(number_format($totalPeserta ?? 0)); ?></h6>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12 col-xl-6">
        <div class="card">
            <div class="card-header">
                <h4>Ringkasan Pelatihan per Kategori</h4>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-6 col-md-3">
                        <div class="border rounded-4 p-3 h-100">
                            <div class="small text-muted mb-1">BK</div>
                            <div class="h5 mb-0 fw-bold"><?php echo e($pelBk); ?></div>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="border rounded-4 p-3 h-100">
                            <div class="small text-muted mb-1">Matematika</div>
                            <div class="h5 mb-0 fw-bold"><?php echo e($pelMat); ?></div>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="border rounded-4 p-3 h-100">
                            <div class="small text-muted mb-1">Tendik</div>
                            <div class="h5 mb-0 fw-bold"><?php echo e($pelTendik); ?></div>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="border rounded-4 p-3 h-100">
                            <div class="small text-muted mb-1">Pembelajaran Mendalam</div>
                            <div class="h5 mb-0 fw-bold"><?php echo e($pelPembelajaranMendalam); ?></div>
                        </div>
                    </div>
                </div>
                <div class="mt-3">
                    <a href="<?php echo e(route('pelatihan.index')); ?>" class="btn btn-outline-primary btn-sm">Lihat detail pelatihan</a>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12 col-xl-6">
        <div class="card">
            <div class="card-header">
                <h4>Sekolah & Guru per Kabupaten</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th>Kabupaten</th>
                                <th class="text-end">Sekolah</th>
                                <th class="text-end">PTK</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $sekolahPerKabupaten; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="fw-semibold"><?php echo e($row->kabupaten ?? '-'); ?></td>
                                    <td class="text-end"><?php echo e(number_format($row->total_sekolah)); ?></td>
                                    <td class="text-end"><?php echo e(number_format($row->total_guru)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center text-muted py-4">Belum ada data.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    <a href="<?php echo e(route('sekolah.index')); ?>" class="btn btn-outline-primary btn-sm">Lihat detail sekolah</a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>