<?php $__env->startSection('page_title','Daftar Hadir'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Daftar Hadir Kegiatan</h5>

        <a href="<?php echo e(route('daftar-hadir.create')); ?>"
           class="btn btn-primary btn-sm">
            <i class="bi bi-plus-circle"></i> Tambah Daftar Hadir
        </a>
    </div>

    <div class="card-body">
        <table class="table table-bordered table-striped">
            <thead class="table-light">
                <tr>
                    <th width="40">No</th>
                    <th>Kegiatan</th>
                    <th>Tanggal</th>
                    <th>Peserta</th>
                    <th>Narasumber</th>
                    <th width="170">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($i + 1); ?></td>

                    <td>
                        <?php echo e($row->suratTugas->nama_kegiatan ?? '-'); ?>

                    </td>

                    <td>
                        <?php echo e(\Carbon\Carbon::parse($row->tanggal)->translatedFormat('d F Y')); ?>

                    </td>

                    <td class="text-center">
                        <?php echo e($row->detail->where('tipe','peserta')->count()); ?> orang
                    </td>

                    <td class="text-center">
                        <?php echo e($row->detail->where('tipe','narasumber')->count()); ?> orang
                    </td>

                    <td class="text-center">
                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                    data-bs-toggle="dropdown">
                                <i class="bi bi-three-dots-vertical"></i>
                            </button>

                            <ul class="dropdown-menu dropdown-menu-end small shadow">

                                
                                <li>
                                    <a class="dropdown-item"
                                       href="<?php echo e(route('daftar-hadir.cetak',$row->id)); ?>"
                                       target="_blank">
                                        <i class="bi bi-eye me-2 text-primary"></i>
                                        Lihat / Cetak
                                    </a>
                                </li>

                                
                                <li>
                                    <a class="dropdown-item"
                                       href="<?php echo e(route('daftar-hadir.edit',$row->id)); ?>">
                                        <i class="bi bi-people me-2 text-success"></i>
                                        Kelola Peserta
                                    </a>
                                </li>

                                
                                <li>
                                    <a class="dropdown-item"
                                       href="<?php echo e(route('daftar-hadir-narasumber.index',$row->id)); ?>">
                                        <i class="bi bi-mic me-2 text-info"></i>
                                        Kelola Narasumber
                                    </a>
                                </li>

                                <li><hr class="dropdown-divider"></li>

                                
                                <li>
                                    <form action="<?php echo e(route('daftar-hadir.destroy',$row->id)); ?>"
                                          method="POST"
                                          onsubmit="return confirm('Yakin hapus daftar hadir ini?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="dropdown-item text-danger">
                                            <i class="bi bi-trash me-2"></i>
                                            Hapus
                                        </button>
                                    </form>
                                </li>

                            </ul>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center text-muted">
                        Belum ada data daftar hadir
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/kegiatan/daftar-hadir/index.blade.php ENDPATH**/ ?>