<?php $__env->startSection('title', 'Kuitansi - BGTK DKI'); ?>
<?php $__env->startSection('page_title', 'Administrasi Keuangan - Kuitansi'); ?>
<?php $__env->startSection('page_subtitle', 'Kelola kuitansi honor/perintah pembayaran per PTK'); ?>

<?php $__env->startSection('content'); ?>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show small" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show small" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">

            <div
                class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3 mb-3">
                <div>
                    <h6 class="mb-1">Pencarian Kuitansi</h6>
                    <small class="text-muted">
                        Cari berdasarkan nama PTK, NIP, atau NUPTK.
                    </small>
                </div>

                <div class="d-flex gap-2">
                    <a href="<?php echo e(route('admin.keuangan.kuitansi.create')); ?>" class="btn btn-success btn-sm">
                        <i class="bi bi-plus-lg me-1"></i> Tambah Kuitansi
                    </a>
                </div>
            </div>

            <form method="GET" action="<?php echo e(route('admin.keuangan.kuitansi.index')); ?>" class="row g-2 align-items-end">

                <div class="col-12 col-md-6">
                    <label class="form-label small mb-1">Nama / NIP / NUPTK</label>
                    <input type="text" name="search" value="<?php echo e($search ?? ''); ?>" class="form-control form-control-sm"
                        placeholder="Contoh: Dr. Nahdiana, 1969..., 12345...">
                </div>

                <div class="col-12 col-md-3">
                    <label class="form-label small mb-1">Tahun Anggaran</label>
                    <input type="text" name="tahun" value="<?php echo e($tahun ?? ''); ?>" class="form-control form-control-sm"
                        placeholder="2025">
                </div>

                <div class="col-12 col-md-3 d-flex gap-2">
                    <button type="submit" class="btn btn-dark btn-sm w-100">
                        <i class="bi bi-search me-1"></i> Terapkan
                    </button>
                    <a href="<?php echo e(route('admin.keuangan.kuitansi.index')); ?>"
                        class="btn btn-outline-secondary btn-sm d-none d-md-inline-flex">
                        Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    
    <div class="card border-0 shadow-sm">
        <div class="card-body">

            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Daftar Kuitansi</h6>

                <?php if(isset($rows) && method_exists($rows, 'total')): ?>
                    <small class="text-muted">
                        Menampilkan <?php echo e($rows->total()); ?> data
                        (<?php echo e($rows->firstItem() ?? 0); ?> - <?php echo e($rows->lastItem() ?? 0); ?>)
                    </small>
                <?php endif; ?>
                
                <a href="<?php echo e(route('admin.keuangan.kuitansi.downloadAll')); ?>" class="btn btn-sm btn-dark">
                    <i class="bi bi-archive me-1"></i> Download Semua Kuitansi
                </a>
            </div>

            <div class="table-responsive mt-2">
                <table class="table table-sm table-hover align-middle">
                    <thead class="table-light small text-uppercase">
                        <tr>
                            <th>PTK</th>
                            <th>Pelatihan</th>
                            <th class="text-center">Tahun</th>
                            <th>Bukti Kas</th>
                            <th class="text-end">Honor</th>
                            <th class="text-end">PPH21</th>
                            <th class="text-end">Diterima</th>
                            <th class="text-center">Tanggal</th>
                            <th class="text-center" style="width: 160px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="small">
                        <?php $__empty_1 = true; $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="fw-semibold">
                                        <?php echo e($r->ptk->nama_guru ?? $r->ptk->nama ?? '-'); ?>

                                    </div>

                                    <div class="text-muted" style="font-size: 11px;">
                                        NIP: <?php echo e($r->ptk->nip ?? '-'); ?> <br>

                                        <?php if(isset($r->ptk->nuptk)): ?>
                                            NUPTK: <?php echo e($r->ptk->nuptk); ?>

                                        <?php endif; ?>
                                    </div>
                                </td>

                                </td>
                                <td>
                                    <?php echo e($r->pelatihan->nama_pelatihan ?? '-'); ?>

                                </td>
                                <td class="text-center">
                                    <?php echo e($r->tahun_anggaran ?? '-'); ?>

                                </td>
                                <td>
                                    <?php echo e($r->bukti_kas_no ?? '-'); ?>

                                </td>
                                <td class="text-end">
                                    Rp <?php echo e(number_format($r->honor_bruto ?? 0, 0, ',', '.')); ?>

                                </td>
                                <td class="text-end">
                                    Rp <?php echo e(number_format($r->pph21_amount ?? 0, 0, ',', '.')); ?>

                                </td>
                                <td class="text-end fw-semibold">
                                    Rp <?php echo e(number_format($r->jumlah_diterima ?? 0, 0, ',', '.')); ?>

                                </td>
                                <td class="text-center">
                                    <?php echo e(optional($r->tanggal_kuitansi)->format('d-m-Y') ?? '-'); ?>

                                </td>


                                <td class="text-center">
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </button>

                                        <ul class="dropdown-menu dropdown-menu-end small shadow">

                                            <li>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('admin.keuangan.kuitansi.show', $r->id)); ?>">
                                                    <i class="bi bi-eye me-2 text-primary"></i> Detail
                                                </a>
                                            </li>

                                            <li>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('admin.keuangan.kuitansi.edit', $r->id)); ?>">
                                                    <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                                </a>
                                            </li>

                                            <li>
                                                <a class="dropdown-item" target="_blank"
                                                    href="<?php echo e(route('admin.keuangan.kuitansi.print', $r->id)); ?>">
                                                    <i class="bi bi-printer me-2 text-secondary"></i> Print
                                                </a>
                                            </li>

                                            <li>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('admin.keuangan.kuitansi.download', $r->id)); ?>">
                                                    <i class="bi bi-download me-2 text-success"></i> Download PDF
                                                </a>
                                            </li>

                                            <li>
                                                <form action="<?php echo e(route('admin.keuangan.kuitansi.destroy', $r->id)); ?>"
                                                    method="POST"
                                                    onsubmit="return confirm('Yakin ingin menghapus data kuitansi ini?');">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="dropdown-item text-danger">
                                                        <i class="bi bi-trash me-2"></i> Hapus
                                                    </button>
                                                </form>
                                            </li>

                                        </ul>
                                    </div>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="text-center text-muted py-4">
                                    Belum ada data kuitansi.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            
            <?php if(isset($rows) && method_exists($rows, 'links')): ?>
                <div class="mt-3">
                    <?php echo e($rows->links()); ?>

                </div>
            <?php endif; ?>

        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/keuangan/kuitansi/index.blade.php ENDPATH**/ ?>